package jp.sourceforge.shovel;

public enum EscapeType {
    XML     ("xml"),
    JSON    ("json");
    
    String type_;
    public String getType() {
        return type_;
    }
    public void setType(String type) {
        type_ = type;
    }
    EscapeType(String type) {
        type_ = type;
    }
    static public EscapeType find(String type) {
        if (type != null) {
            for (EscapeType escapeType : values()) {
                if (type.compareToIgnoreCase(escapeType.getType()) == 0) {
                    return escapeType;
                }
            }
        }
        return XML;
    }
    public boolean isXML() {
        return this == XML;
    }
    public boolean isJSON() {
        return this == JSON;
    }
}
