package jp.sourceforge.shovel;

public enum AccountConfigType {
    SETTINGS        ("settings"),
    PASSWORD        ("password"),
    DEVICE          ("device"),
    NOTICES         ("notices"),
    PICTURE         ("picture"),
    DESIGN          ("design"),
    PROFILE_IMAGE   ("profileImage"),
    RESEND_PASSWORD ("resendPassword"),
    RESET_PASSWORD  ("resetPassword");
    
    String forward_;
    
    AccountConfigType(String forward) {
        forward_ = forward;
    }
    public String getForward() {
        return forward_;
    }
    public static AccountConfigType find(String forward) {
        String[] tokens = forward.split("_");
        if (tokens.length > 1) {
            forward = tokens[0] +
                      tokens[1].substring(0, 1).toUpperCase() +
                      tokens[1].substring(1);
        }
        for(AccountConfigType type :AccountConfigType.values()) {
            if(type.getForward().compareToIgnoreCase(forward) == 0) {
                return type;
            }
        }
        return null;
    }
    public boolean isSettings() {
        return this == SETTINGS;
    }
    public boolean isPassword() {
        return this == PASSWORD;
    }
    public boolean isDevice() {
        return this == DEVICE;
    }
    public boolean isNotices() {
        return this == NOTICES;
    }
    public boolean isPicture() {
        return this == PICTURE;
    }
    public boolean isDesign() {
        return this == DESIGN;
    }
    public boolean isProfileImage() {
        return this == PROFILE_IMAGE;
    }
    public boolean isResendPassword() {
        return this == RESEND_PASSWORD;
    }
    public boolean isResetPassword() {
        return this == RESET_PASSWORD;
    }
}
