/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util.io.filter;

import java.io.File;
import java.io.FileFilter;

import net.morilib.util.io.Wildcard;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/12/22
 */
public class WildcardFileFilter implements FileFilter {

	//
	private Wildcard glob;

	/**
	 * @param g
	 */
	public WildcardFileFilter(String g) {
		glob = Wildcard.compile(g);
	}

	/* (non-Javadoc)
	 * @see java.io.FileFilter#accept(java.io.File)
	 */
	@Override
	public boolean accept(File pathname) {
		return glob.matches(pathname.getName());
	}

}
