﻿using Psychlops;

namespace PsychlopsSilverlightApp
{

	public class PsychlopsMain
	{


		public void psychlops_main() {

       Canvas display = new Canvas(768,768);

       double rect_size = 100;
       double rect_lum  = 0.5;
       double bg_lum    = 0.5;
       double size = 250.0;
   double sigma;
   sigma = size/6.0;
   double lambda;
   lambda = 6*sigma;
   int envelopemode = 0;
   double refresh = display.getRefreshRate();
   double[] SF=new double[2];

   SF[0]=4.0;
   SF[1]=4.0;

   double phase=0;

   double[] initphase = new double[2];
   double _i, _j, _x, _y, _x2, _y2, col;
   double amplitude = 1.0;

       Rectangle fixation1 = new Rectangle(3,9);
   Rectangle fixation2 = new Rectangle(9,3);
       fixation1.centering();
       fixation2.centering();
   Rectangle contrastrect = new Rectangle();
   contrastrect.set(760,760);

   Image envelope = new Image();
   Psychlops.Color bglum= new Color(0.5,0.5,0.5);
   Psychlops.Color masklum = new Color(0.5,0.5,0.5,0.5);

       Interval rng = new Interval();


       Psychlops.Widgets.Slider TF;
       TF = new Psychlops.Widgets.Slider("TF", 0.25<=rng<=2.0 , 0.1);
   TF.value=0.75;



       Psychlops.Widgets.Slider SFs;
       SFs = new Psychlops.Widgets.Slider("SF", 4.0<=rng<=16.0 ,  4.0);
       SFs.value = 4.0;

   Psychlops.Widgets.Slider contrast;
       contrast= new Psychlops.Widgets.Slider("Contrast", 0.0<=rng<=1.0 ,  0.1);
       contrast.value = 0.1;


       var element =  StaticFunctions.NewArray<Figures.ShaderGabor>(2);
    for (int i = 0; i < element.Length; i++){
           element[i].setSigma(sigma); // set a size of patch as a halfwidth of Gaussian
           element[i].orientation = Math.PI/4.0+Math.PI/2.0*(1-i);//Math.PI/2*(rand()%2);// //set orientations
           initphase[i]=0;
  }



      envelope.set(size, size);
      envelope.clear(bglum);

   for(int i=0; i<size; i++){
       for(int j=0; j<size; j++){
           _i=i-size*0.5;
           _j=j-size*0.5;
           _x=_i*Math.cos(-Math.PI/4.0)+_j*Math.sin(-Math.PI/4.0);
           _y=-_i*Math.sin(-Math.PI/4.0)+_j*Math.cos(-Math.PI/4.0);
           col=Math.exp(-(_x*_x)/(2*Math.pow(sigma*2/6.0,2.0))-(_y*_y)/(2*Math.pow(sigma*2,2.0)));
           envelope.alpha(i,j,1.0-col);

           }
       }


       while(!Keyboard.esc.pushed()) {
           if(Keyboard.spc.pushed())envelopemode++; envelopemode%=2;
       Display.clear(bglum);
       phase ++;
       //phase = fmod(phase,60);

       for(int i=0; i<2; i++) {
           element[i].phase =(SF[i]/SF[0])*amplitude*
Math.PI*Math.sin(Math.PI/2*i+2*Math.PI*phase*TF/refresh);
           element[i].wavelength = lambda/SF[i];
           element[i].contrast = contrast;
       }


       element[0].centering().shift(-size * 0.6, -size * 0.6);
       element[0].draw();
       element[1].centering().shift(size*0.6,-size*0.6);
       element[1].draw();
               element[1].centering().shift(-size*0.6,size*0.6);
       element[1].draw();
               element[0].centering().shift(size*0.6,size*0.6);
       element[0].draw();


               if(envelopemode>0){
                   envelope.centering().shift(size*0.6,-size*0.6).draw();
                   envelope.centering().shift(-size*0.6,size*0.6).draw();
                   }
       masklum.set(bg_lum, bg_lum, bg_lum, 1-contrast);
       contrastrect.centering();
       contrastrect.draw(masklum);
       fixation1.centering().shift(size*2,0.0);
       fixation1.draw(Color.red);
       fixation2.centering().shift(size*2,0.0);
       fixation2.draw(Color.red);

	   Display.var(Mouse.x, 300, 300);
	   Display.var(Mouse.y, 300, 320);

               Display.flip();


       }

}



	}

}
/*

using Psychlops;
//Position Bias Program
namespace PsychlopsSilverlightApp
{

	public class PsychlopsMain
	{
		Canvas cnvs;
		Image img, img2, img3;
		int isize = 40;
		int frames;
		Psychlops.Widgets.Slider tfreq;
		Psychlops.Widgets.Slider contrast;
		Psychlops.Widgets.Slider lambda;



		public void psychlops_main()
		{
			cnvs = new Canvas(300, 600);
			Interval rng = new Interval();
			tfreq = new Psychlops.Widgets.Slider("Temporal Frequency(Hz)", -5 <= rng <= 5, 3.0);
			contrast = new Psychlops.Widgets.Slider("Contrast", 0.0 <= rng <= 1.0, 0.25);
			lambda = new Psychlops.Widgets.Slider("Wave Length", 10.0 <= rng <= 120.0, 30);

			img = new Image(isize * 2, isize * 2);
			img2 = new Image(isize * 2, isize * 2);
			img3 = new Image(isize * 2, isize * 2);

			var gabor1 = StaticFunctions.NewArray<Figures.ShaderGabor>(100);
			foreach (var g in gabor1)
			{
				g.setSigma(isize/8).centering().shift(Math.random(300) - 150, Math.random(600) - 300);
				//g.setSize(isize).centering().shift(Math.random(300) - 150, Math.random(600) - 300);
				g.orientation = Math.random(2 * Math.PI);
				//g.orientation2 = Math.random(2 * Math.PI);
			}

			while (true)
			{
				cnvs.clear(new Color(0.5));

				Figures.drawGabor(ref img, isize / 8, 1 / lambda, contrast, 0.5 * Math.PI, (double)frames * 2.0 * Math.PI * tfreq / 60);
				Figures.drawGabor(ref img2, isize / 8, 1 / lambda, contrast, 0.5 * Math.PI, (double)frames * 2.0 * Math.PI * -tfreq / 60);
				Figures.drawGabor(ref img3, isize / 8, 1 / lambda, contrast, 0.5 * Math.PI, (double)frames * 2.0 * Math.PI * tfreq / 60);


				//img.centering().shift(0, -isize * 1.5).draw();
				//img2.centering().draw();
				//img3.centering().shift(0, isize * 1.5).draw();


				//foreach (var g in gabor1)
				for (int i = 0; i < gabor1.Length; i++)
				{
					gabor1[i].wavelength = lambda;
					gabor1[i].phase = (double)frames * 2.0 * Math.PI * tfreq / 60;
					gabor1[i].contrast = contrast;
					//g.wavelength2 = lambda * 2;
					//g.phase2 = (double)frames * 2.0 * Math.PI * tfreq / 60;
					//g.contrast2 = contrast / 2;
					gabor1[i].draw();
				}

				if (!Mouse.left.pressed()) frames++;

				cnvs.flip();
			}
		}
	}
}


/*
///+ Prefix linkto BasicCode1
//// Lines for set up Psychlops environment
using Psychlops;

namespace PsychlopsSilverlightApp
{

	public class PsychlopsMain
	{
		///- Prefix linkto BasicCode1


		///+ Main Routine
		//// Psychlops runs at the first line of this function psychlops_main().
		public void psychlops_main()
		{

			///+ 0 SetGlobal
			////Prepare global parameters
			Rectangle p1 = new Rectangle(1,1);
			Color col1 = new Color();
			double width=50;
			double height=10;
			double lambda=60;
			double lmean=0.25, contrast = 0.5;
			double x0 = 0;
			double y0 = 0;
		    double pitch = 1;
			Canvas disp = new Canvas(Canvas.window, Display.secondary);
			
			var fieldW_ = Psychlops.Widgets.Browser.Element.byID("fieldW");
			var fieldH_ = Psychlops.Widgets.Browser.Element.byID("fieldH");
			var wL_     = Psychlops.Widgets.Browser.Element.byID("wL");
			var Cont_   = Psychlops.Widgets.Browser.Element.byID("Cont");
			var ix_     = Psychlops.Widgets.Browser.Element.byID("ix");
			var iy_     = Psychlops.Widgets.Browser.Element.byID("iy");
			var gap_    = Psychlops.Widgets.Browser.Element.byID("gap");
			///- 0 SetGlobal

			///+ 1 Initialize
			////initialize
			p1.centering().shift(-width*0.5 + x0, -height*0.5 + y0); //Move a point to the initial position.
			///- 1 Initialize

			///+ 2 Drawing
			 ////drawing objects
			for(int i=0; i < width; i++)
			{
				col1.set(lmean*((contrast*Math.sin((2*Math.PI*i/lambda)))+1)); //Set a color.

				///+ 2.1 Drawing a column
				////drawing a column
				for(int j=0;j < height; j++)
				{
					p1.draw(col1);
					p1.shift(0, pitch);
				}
				///- 2.1 Drawing a column

				p1.shift(1, -height * pitch); //back to vertical intitial point after drawing one column.
			}
			disp.flip();
			///- 2 Drawing

			while (!Keyboard.spc.pushed()) { }; //Wait until space key is pressed.
		}


	}

}
 * */


/*
///+ Prefix
//// Lines for set up Psychlops environment
using Psychlops;

namespace PsychlopsSilverlightApp
{

	public class PsychlopsMain
	{///- Prefix



		///+ Main Routine
		//// Psychlops runs at the first line of this function psychlops_main().
		public void psychlops_main()
		{
			Canvas window = new Canvas(300, 300); //Create a window. Here, window variables are preset mode.

			var FIGURE = Psychlops.Widgets.Browser.Element.byID("FIGURE");
			var SIZE_X_ = Psychlops.Widgets.Browser.Element.byID("SIZE_X");
			var SIZE_Y_ = Psychlops.Widgets.Browser.Element.byID("SIZE_Y");
			var COLOR_R = Psychlops.Widgets.Browser.Element.byID("COLOR_R");
			var COLOR_G = Psychlops.Widgets.Browser.Element.byID("COLOR_G");
			var COLOR_B = Psychlops.Widgets.Browser.Element.byID("COLOR_B");
			var COLOR_BG = Psychlops.Widgets.Browser.Element.byID("COLOR_BG");
			var Period_Size = Psychlops.Widgets.Browser.Element.byID("Period_Size");
			var Period_Position = Psychlops.Widgets.Browser.Element.byID("Period_Position");
			var Speed_HSize_ = Psychlops.Widgets.Browser.Element.byID("Speed_HSize");
			var Speed_VSize = Psychlops.Widgets.Browser.Element.byID("Speed_VSize");
			var Speed_VMotion = Psychlops.Widgets.Browser.Element.byID("Speed_VMotion");
			double SIZE_X = SIZE_X_, SIZE_Y = SIZE_Y_;

			///+ 2
			////  Set a figure size, position and color.
			Rectangle figure = new Rectangle();
			Ellipse figure2 = new Ellipse();
			figure.set(SIZE_X_, SIZE_Y_); // Set the size of figure.
			figure2.set(SIZE_X_, SIZE_Y_); // Set the size of figure.
			figure.centering().shift(0, 0); // Move the figure to the starting point.
			figure2.centering().shift(0, 0); // Move the figure to the starting point.
			///- 2

			int frame = 0;
			int looming_direction = 1, motion_dir = 1;
			double direction = 1.0;
			//looming_direction is a variable for size change.
			//motion_dir is a variable for motion direction.
			///+ 3 Drawing loop
			//// Draw each frames in a "while loop".
			while (!Keyboard.esc.pushed())
			{ //exit a program when the escape key is pressed down.
				window.clear(COLOR_BG); // Clear the window with a designated gray-scale level.

				///+ 3.1
				//// Calculate object's position and size for each frame.

				if (frame % Period_Size == 0)
				{ // a direction of size change will reverse at designated frames.
					looming_direction = looming_direction * -1;
				}

				if (frame % Period_Position == 0)
				{ // motion direction will reverse at designated frames.
					motion_dir *= -1;
				}

				///- 3.1

				///+ 3.2 
				//// Settting figure's properties
				figure.resize(figure.getWidth() + looming_direction * 1, // Scaling the figure in a direction given by "looming_direction".
								 figure.getHeight() + looming_direction * 1);// Scaling the figure in a direction given by "looming_direction".
				figure.shift(motion_dir * 1.0, motion_dir * Speed_VMotion);// Move the figure for 1 pixel in direction given by "motion_dir". 
				figure2.resize(figure.getWidth() + looming_direction * 1, // Scaling the figure in a direction given by "looming_direction".
								figure.getHeight() + direction * Speed_VSize);// Scaling the figure in a direction given by "looming_direction".
				figure2.shift(motion_dir * 1.0, motion_dir * Speed_VMotion);// Move the figure for 1 pixel in direction given by "motion_dir". 
				/*
				figure.resize(figure.getWidth() + looming_direction * 1, // Scaling the figure in a direction given by "looming_direction".
							 figure.getHeight() + looming_direction * 1);// Scaling the figure in a direction given by "looming_direction".
				figure.shift(motion_dir * 1.0, motion_dir * Speed_VMotion);// Move the figure for 1 pixel in direction given by "motion_dir". 
				figure2.resize(figure.getWidth() + looming_direction * 1, // Scaling the figure in a direction given by "looming_direction".
								figure.getHeight() + direction * Speed_VSize);// Scaling the figure in a direction given by "looming_direction".
				figure2.shift(motion_dir * 1.0, motion_dir * Speed_VMotion);// Move the figure for 1 pixel in direction given by "motion_dir". 
				 * * /
				///- 3.2

				///+ 3.3 
				////Drawing
				if ("Rectangle".Equals(FIGURE))
				{
					figure.draw(new Color(COLOR_R, COLOR_G, COLOR_B)); // Drawing the figure with a designated color at designated position.
				}
				else
				{
					figure2.draw(new Color(COLOR_R, COLOR_G, COLOR_B)); // Drawing the figure with a designated color at designated position.
				}
				window.flip(); // Reflect the drawing for the display by flipping frame buffers.
				///- 3.3

				///+ 3.4
				////make a step for next frames 
				frame++;
				///- 3.4
			}
			///- 3 Drawing loop

		}
		///- Main Routine


	}

}



/*
//The reversed-phi motion.
//Anstis (1970)
//Phi movement as a subtraction process. Vision Res 10:1411?1430

///+ Prefix
//// Include Psychlops Package
using Psychlops;

namespace PsychlopsSilverlightApp
{

	public class PsychlopsMain
	{

		///- Prefix

		///+ Stimulus drawing function
		//// A function for stimulus drawing (main body)
		void RectLuminance()
		{

			///+ Preperation
			//// Declare and initialize local variables
			double rect_size = 20;

			double bg_lum = 0.5;
			double radii = 200;
			double rect_lum;
			int element_number = 25;
			int radial_row = 5;

			double rotation_tf = 0.2;
			double polarity = 1;
			double rotation;

			double contrastflag = 1;
			int period = 3;
			double refresh;

			Canvas display = new Canvas(Canvas.window); //Prepare drawing window
			refresh = Display.getRefreshRate();

			Ellipse rect = new Ellipse();
			rect.set(rect_size, rect_size);

			Ellipse fixation = new Ellipse(5, 5);
			fixation.centering();

			Letters let1 = new Letters("Press Space key to change stimulus type");
			let1.centering().shift(-180, 220);
			Letters let2 = new Letters("Phi");
			let2.centering().shift(-10, 200);
			Letters let3 = new Letters("Reversed-Phi");
			let3.centering().shift(-60, 200);

			rotation = Math.random(2 * Math.PI);

			///+ user interface
			////register variables to demo circumstances
			Interval rng = new Interval();

			Psychlops.Widgets.Slider rect_contrast;
			rect_contrast = new Psychlops.Widgets.Slider("Contrast", 0.1 <= rng <= 1.0, 0.1);
			rect_contrast.value = 0.5;
			///- user interface
			///- Preperation

			///+ Main loop
			////Main loop
			int frame = 0;
			//AppState::setThreadPriority(AppState::HIGH);
			while (true)
			{
				frame++;
				if (Keyboard.spc.pushed()) contrastflag = -contrastflag;
				if (contrastflag < 0) polarity = -polarity;
				rotation = 2 * Math.PI * rotation_tf * frame * period / refresh;

				for (int frame_now = 0; frame_now < period; frame_now++)
				{
					Display.clear(new Color(bg_lum));
					for (int j = 0; j < radial_row; j++)
					{
						rect.resize(rect_size * (j + radial_row) / 10.0, rect_size * (j + radial_row) / 10.0);
						for (double i = 0; i < element_number; i++)
						{
							rect_lum = bg_lum * (1.0 + polarity * rect_contrast);
							rect.centering().shift(radii * (j + radial_row) / 10.0 * Math.cos(rotation + i * 2 * Math.PI / element_number), radii * (j + radial_row) / 10.0 * Math.sin(rotation + i * 2 * Math.PI / element_number));
							rect.draw(rect_lum);
						}
					}
					fixation.draw(Color.red);
					let1.draw();
					if (contrastflag > 0) let2.draw();
					else let3.draw();
					Display.flip();
				}
			}
			///- Main loop
			//AppState::setThreadPriority(AppState::NORMAL);
		}
		///- Stimulus drawing function

		///+ Main function for demo circumstances
		//// Psychlops Main function
		public void psychlops_main()
		{
			///+ Demo circumstances
			//// Spells for run demonstration circumstances
			Procedure p = new Procedure();
			//p.setDesign(Procedure::DEMO); //Designate that this is a demo.
			p.setProcedure(RectLuminance);  //The argument name is a name of drawing function.
			p.run();
			///- Demo circumstances
		}
		///- Main function for demo circumstances

	}

}



/*
//Two types of plaid motion
//E. H. Adelson and J. A. Movshon (1982).
//Phenomenal coherence of moving visual patterns. Nature 300, 523-525

///+ Prefix
//// Include Psychlops Package
using Psychlops;

	namespace PsychlopsSilverlightApp
	{

		public class PsychlopsMain
		{
			///- Prefix

			///+ Global
			// Struct for component paremeters
			struct component
			{
				public double contrast;
				public double orientation;
				public double lambda;
				public double tf;
			}
			///- Global

			///+ Stimulus drawing function
			//// A function for stimulus drawing (main body)
			void drawgratingmovie(Image[] img, component c1, component c2, double contrast, int start, int maxframe, double bg_lum, double alpha)
			{
				double _xp, _xp2, col1, col2;
				double contrast1, contrast2;
				double imageheight, imagewidth;

				contrast1 = contrast*c1.contrast/(c1.contrast+c2.contrast);
				contrast2 = contrast*c2.contrast/(c1.contrast+c2.contrast);

				imageheight = img[0].getHeight();
				imagewidth = img[0].getWidth();

				for(int frame=start; frame<start+maxframe+1; frame++){
					//Display.progressbar(frame, maxframe+1);
					//img[frame].convert(Image::RGBA);
					for(int i=0; i<imagewidth; i++){
						for(int j=0; j<imageheight; j++){
							_xp = Math.sin(c1.orientation)*(i-imagewidth*0.5) + Math.cos(c1.orientation) * (j-imageheight *0.5);
							_xp2 = Math.sin(c2.orientation)*(i-imagewidth*0.5) + Math.cos(c2.orientation) * (j-imageheight *0.5);
							col1 = bg_lum*contrast1*Math.sin(2*Math.PI*_xp/c1.lambda + 2*Math.PI*c1.tf*frame/(double)refresh);
							col2 = bg_lum*contrast2*Math.sin(2*Math.PI*_xp2/c2.lambda + 2*Math.PI*c2.tf*frame/(double)refresh);
							img[frame].pix(i,j,new Color(col1+col2+bg_lum));
							img[frame].alpha(i,j,alpha);
						}
					}
					//img[frame].cache();
				}
			}

			///+ Stimulus drawing function
			//// A function for stimulus drawing (main body)
			void drawplaid() {
				Canvas display = new Canvas(Canvas.window);
				///+ Preperation
				//// Declare and initialize local variables
				int rect_size = 150;
				double rect_lum  = 0.5;
				double bg_lum    = 0.2;
				double duration = 400;

				double[] lambda = new double[2], contrast = new double[2], tf = new double[2];
				double center_orientation = 0.0;
				Image[,] movie = StaticFunctions.NewArray<Image>(2, 120);
				Image[,] component_movie = StaticFunctions.NewArray<Image>(4, 120);
				Image envelope = new Image(), envelope_small = new Image();

				for(int i=0; i<120; i++)
				{
					movie[0, i].set(rect_size, rect_size);
					movie[1, i].set(rect_size, rect_size);
					component_movie[0, i].set(rect_size/2, rect_size/2);
					component_movie[1, i].set(rect_size/2, rect_size/2);
					component_movie[2, i].set(rect_size/2, rect_size/2);
					component_movie[3, i].set(rect_size/2, rect_size/2);
				}
				envelope.set(rect_size, rect_size);
				envelope_small.set(rect_size/2, rect_size/2);

				Letters let1 = new Letters(), let2 = new Letters(), let3 = new Letters();
				let1.str = "Component1";
				let2.str = "Component2";
				let3.str = "Superposition";
				let1.centering().shift(-rect_size*1.25, -rect_size);
				//let1.cache();
				let2.centering().shift(rect_size*1.25, -rect_size);
				//let2.cache();
				let3.centering().shift(0.0, rect_size*0.75);
				//let3.cache();

				component c1, c2, c0;
				c0 = new component{ 0.0,0.0,1.0,1.0 }; //dummy for component movie
				///+ type-I
				// Prepare Type-I plaid movie
				center_orientation = 0.0;
				orientation_offset = Math.PI/6;
				contrast[0] = 1.0, contrast[1] = 1.0;
				lambda[0] = 30.0, lambda[1] = 30.0;
				tf[0] = 1.0; tf[1] = 1.0;

				c1 = {contrast[0], center_orientation-orientation_offset, lambda[0], tf[0]};
				c2 = {contrast[1], center_orientation+orientation_offset, lambda[1], tf[1]};

			drawgratingmovie(movie[0],c1, c2, 0.5, 0, refresh_int, bg_lum, 1.0);
			drawgratingmovie(component_movie[0],c0, c2, 0.5, 0, refresh_int, bg_lum, 1.0);
			drawgratingmovie(component_movie[1],c1, c0, 0.5, 0, refresh_int, bg_lum, 1.0);
			///- type-I

			///+ type-II
			// Prepare Type-II plaid movie
			center_orientation = -0.0, orientation_offset = Math.PI/12;
			contrast[0] = 1.0, contrast[1] = 1.0;
			lambda[0] = 30.0, lambda[1] = 30.0;
			tf[0] = 1.0; tf[1] = 4.0;

			c1 = {contrast[0], center_orientation-orientation_offset, lambda[0], tf[0]};
			c2 = {contrast[1], center_orientation+orientation_offset, lambda[1], tf[1]};

			drawgratingmovie(movie[1],c1, c2, 0.5, 0, refresh_int, bg_lum, 1.0);
			drawgratingmovie(component_movie[2],c0, c2, 0.5, 0, refresh_int, bg_lum, 1.0);
			drawgratingmovie(component_movie[3],c1, c0, 0.5, 0, refresh_int, bg_lum, 1.0);
			///- type-II

			///+ gaussian
			//draw Gaussian envelopes
			envelope.clear(new Color(bg_lum)); //clear offscreen image
			double _x, _y;
			for(int i=0; i<rect_size; i++){
			_x=i-0.5*rect_size;
			for(int j=0; j<rect_size; j++){
			_y=j-0.5*rect_size;
			envelope.alpha(i,j,1.0-Math.exp(-((_x*_x+_y*_y)/ (2.0*pow(rect_size/6.0, 2.0) ))));
			}
			}

			envelope_small.clear(new Color(bg_lum)); //clear offscreen image
			for(int i=0; i<rect_size*0.5; i++){
			_x=i-0.25*rect_size;
			for(int j=0; j<rect_size*0.5; j++){
			_y=j-0.25*rect_size;
			envelope_small.alpha(i,j,1.0-Math.exp(-((_x*_x+_y*_y)/ (2.0*pow(rect_size/12.0, 2.0) ))));
			}
			}
			envelope.cache(); //send offscreen image from main memory to GPU
			envelope_small.cache(); //send offscreen image from main memory to GPU
			///- gaussian

			///+ user interface
			// Draw user interface
			Widgets::SelectBox stimulus_type;
			stimulus_type.area.set(120, 20);
			stimulus_type.append(L"TypeI");
			stimulus_type.append(L"TypeII");
			stimulus_type.centering().shift(-120.0,250.0);

			Psychlops::Widgets::SelectBox stimulus_type2;
			stimulus_type2.area.set(120, 20);
			stimulus_type2.append(L"Continuous");
			stimulus_type2.append(L"Periodic");
			stimulus_type2.centering().shift(120.0,250.0);

			Psychlops::Widgets::Slider duration_slider;
			duration_slider.area.set(100,20);
			duration_slider.centering().shift(120,280.0);
			Interval rng = new Interval();
			duration_slider.link(duration, 50<=rng<=950, 50.0, 50.0);
			///- user interface
			///- Preperation

			///+ Main loop
			int frame = 0;
			int period = refresh_int;
			int movienum;
			while(!Keyboard.esc.pushed()) {
			Display.clear(new Color(bg_lum));
			movienum = stimulus_type.getSelected(); //if "Type-I" is selected, 0, else frame refresh per sec

			in;
			else period = refresh_int;

			if(frame>0){
			movie[movienum, frame].centering().draw();
			envelope.centering().draw();
			component_movie[movienum*2, frame].centering().shift(-rect_size*0.5, -rect_size).draw();
			envelope_small.centering().shift(-rect_size*0.5, -rect_size).draw();
			component_movie[movienum*2+1, frame].centering().shift(rect_size*0.5, -rect_size).draw();
			envelope_small.centering().shift(rect_size*0.5, -rect_size).draw();
			}

			///+ draw user interface
			let1.draw(0.75);
			let2.draw(0.75);
			let3.draw(0.75);
			stimulus_type.draw();
			stimulus_type2.draw();
			if(stimulus_type2.getSelected())duration_slider.draw();
			///- draw user interface
			Display.flip();
			if(frame++ >= period) frame -= refresh_int;
			}
			///- Main loop

			}
			///- Stimulus drawing function

		///+ Main function for demo circumstances
		public void psychlops_main() {
			///+ Demo circumstances
			//// Spells for run demonstration circumstances
			Procedure p = new Procedure();
			//p.setDesign(Procedure::DEMO); //Designate that this is a demo.
			p.setProcedure(drawplaid);  //The argument name is a name of drawing function.
			p.run();
			///- Demo circumstances
		}
	}
}
*/
