﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;



namespace Psychlops{

	public interface Shape : Internal.PrimitiveFigure
	{
		Color fill { get; set; }
		Stroke stroke { get; set; }
	}
	public static class ShapeExtention
	{
		public static void draw(this Shape drawee, double c)
		{
			drawee.draw( new Color(c) );
		}
		public static void draw(this Shape drawee, Color c)
		{
			Color tmp_col = drawee.fill;
			Stroke tmp_strk = drawee.stroke;
			drawee.fill = c;
			drawee.stroke = new Stroke();
			drawee.draw();
			drawee.fill = tmp_col;
			drawee.stroke = tmp_strk;
		}
		public static void draw(this Shape drawee, Stroke strk)
		{
			Color tmp_col = drawee.fill;
			Stroke tmp_strk = drawee.stroke;
			drawee.fill = new Color(0,0,1,1);
			drawee.stroke = strk;
			drawee.draw();
			drawee.fill = tmp_col;
			drawee.stroke = tmp_strk;
		}
	}

	public partial struct Stroke
	{
		public double thick;
		public Color color;
		public Stroke(Color c, double t)
		{
			color = c;
			thick = t;
		}
		public void set(Color c, double t)
		{
			color = c;
			thick = t;
		}
		public static readonly Stroke null_line = new Stroke(Color.null_color, 0);
		public static readonly Stroke hair_line = new Stroke(Color.white, 1);
	}

	public partial class Line : Shape
	{
		public Point begin, end;
		public Point datum
		{
			get { return begin; }
			set { begin = value; }
		}

		//public static Line[] this[int x] { get { return Array(x); } }
		//public static Line[,] this[int x, int y] { get { return Array(x, y); } }
		public static Line[] Array(int ind)
		{
			Line[] l = new Line[ind];
			for(int i=0; i<ind; i++) { l[i] = new Line(); }
			return l;
		}
		public static Line[,] Array(int indx, int indy)
		{
			Line[,] l = new Line[indx, indy];
			for (int i = 0; i < indx; i++) { for (int j = 0; j < indy; j++) { l[i, j] = new Line(); } }
			return l;
		}


		public Line()
		{
			fill = Color.white;
			stroke = Stroke.hair_line;
			set(0,0,0,0);
		}
		public Line(double x1, double y1, double x2, double y2)
		{
			fill = Color.white;
			stroke = Stroke.hair_line;
			set(x1, y1, x2, y2);
		}
		public Line(Point v1, Point v2)
		{
			fill = Color.white;
			stroke = Stroke.hair_line;
			set(v1, v2);
		}
		public Line set(double x1, double y1, double x2, double y2)
		{
			begin.set(x1, y1);
			end.set(x2, y2);
			return this;
		}
		public Line set(Point v1, Point v2)
		{
			begin = v1;
			end   = v2;
			return this;
		}

		public Figure shift(Point p)
		{
			begin += p;
			end   += p;
			return this;
		}
		public Figure centering(Point p)
		{
			double h = width, v = height;
			begin.x = p.x - h / 2.0;
			begin.y = p.y - v / 2.0;
			end.x = begin.x + h;
			end.y = begin.y + v;
			return this;
		}

		public virtual void draw()
		{
			Main.drawable.line(this);
		}

		public double left { get { return begin.x < end.x ? begin.x : end.x; } }
		public double top { get { return begin.y < end.y ? begin.y : end.y; ; } }
		public double right { get { return begin.x > end.x ? begin.x : end.x; ; } }
		public double bottom { get { return begin.y > end.y ? begin.y : end.y; ; } }
		public double width { get { return Math.abs(begin.x - end.x); } }
		public double height { get { return Math.abs(begin.y - end.y); } }
		public double getLeft() { return left; }
		public double getTop() { return top; }
		public double getRight() { return right; }
		public double getBottom() { return bottom; }
		public double getWidth() { return width; }
		public double getHeight() { return height; }

		public Color fill { get; set; }
		public Stroke stroke { get; set; }
	}

	public partial class Rectangle_
	{
		public Point v1, v2;

		public double left { get { return v1.x; } }
		public double top { get { return v1.y; } }
		public double right { get { return v2.x; } }
		public double bottom { get { return v2.y; } }
		public double width { get { return Math.abs(v1.x - v2.x); } }
		public double height { get { return Math.abs(v1.y - v2.y); } }
		public double getLeft() { return left; }
		public double getTop() { return top; }
		public double getRight() { return right; }
		public double getBottom() { return bottom; }
		public double getWidth() { return width; }
		public double getHeight() { return height; }



		public Color fill { get; set; }
		public Stroke stroke { get; set; }

		public override string ToString()
		{
			return "Left:" + left.ToString() + " Top:" + top.ToString() + " Right:" + right.ToString() + " Bottom:" + bottom.ToString();
		}
	}


	public partial class Rectangle : Shape
	{
		public Point v1, v2;

		//public static Rectangle[] this[int x] { get { return Array(x); } }
		//public static Rectangle[,] this[int x, int y] { get { return Array(x, y); } }
		public static Rectangle[] Array(int ind)
		{
			Rectangle[] l = new Rectangle[ind];
			for (int i = 0; i < ind; i++) { l[i] = new Rectangle(); }
			return l;
		}
		public static Rectangle[,] Array(int indx, int indy)
		{
			Rectangle[,] l = new Rectangle[indx, indy];
			for (int i = 0; i < indx; i++) { for (int j = 0; j < indy; j++) { l[i, j] = new Rectangle(); } }
			return l;
		}


		public Rectangle()
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			set(0,0);
		}
		public Rectangle(double wid, double hei)
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			set(wid, hei);
		}
		public Rectangle(Rectangle another)
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			v1 = another.v1;
			v2 = another.v2;
		}
		public Rectangle set(double wid, double hei)
		{
			v1.set(0, 0, 0);
			v2.set(wid, hei, 0);
			return this;
		}
		Rectangle set(Point po1, Point po2) {
			v1 = po1;
			v2 = po2;
			return this;
		}
		public Rectangle set(double l, double t, double r, double b)
		{
			v1.set(l, t, 0);
			v2.set(r, b, 0);
			return this;
		}
		public Rectangle set(Rectangle another)
		{
			v1 = another.v1;
			v2 = another.v2;
			return this;
		}

		public Rectangle resize(double width, double height)
		{
			Point po = center;
			set(width, height);
			centering(po);
			return this;
		}


		public Point datum
		{
			get { return v1; }
			set { double w = width, h = height; v1 = value; v2 = v1 + new Point(w,h); }
		}
		public Rectangle move_to(Point p) { datum = p; return this; }
		public Rectangle move_to(double x, double y, double z = 0.0) { datum = new Point(x, y, z); return this; }
		public Rectangle locate(Point p) { datum = p; return this; }
		public Rectangle locate(double x, double y, double z = 0.0) { datum = new Point(x, y, z); return this; }

		public Figure shift(Point p)
		{
			v1 += p;
			v2 += p;
			return this;
		}
		public Figure centering(Point p)
		{
			double h = width, v = height;
			v1.x = p.x - h / 2.0;
			v1.y = p.y - v / 2.0;
			v2.x = v1.x + h;
			v2.y = v1.y + v;
			return this;
		}

		public virtual void draw()
		{
			Main.drawable.rect(this);
		}
		public bool include(double x, double y)
		{
			return (top <= y) && (left <= x) && (bottom >= y) && (right >= x);
		}
		public bool include(Point p)
		{
			return (top <= p.y) && (left <= p.x) && (bottom >= p.y) && (right >= p.x);
		}
		public bool include(Rectangle rect)
		{
			return (top <= rect.top) && (left <= rect.left) && (bottom >= rect.bottom) && (right >= rect.right);
		}

		public Rectangle alignLeft(double lef)
		{
			return move_to(lef, getTop(), datum.z);
		}
		public Rectangle alignTop(double to_)
		{
			return move_to(getLeft(), to_, datum.z);
		}
		public Rectangle alignRight(double rig)
		{
			return move_to(rig - getWidth(), getTop(), datum.z);
		}
		public Rectangle alignBottom(double bot)
		{
			return move_to(getLeft(), bot - getHeight(), datum.z);
		}

		public void clipped_by(Rectangle source)
		{
			double t = top, l = left, b = bottom, r = right;
			if (top < source.top) { t = source.top; }
			if (left < source.left) { l = source.left; }
			if (bottom > source.bottom) { b = source.bottom; }
			if (right > source.right) { r = source.right; }
			set(l, t, r, b);
		}
		public void clip(Rectangle target)
		{
			double t = top, l = left, b = bottom, r = right;
			if (top < target.top) { t = target.top; }
			if (left < target.left) { l = target.left; }
			if (bottom > target.bottom) { b = target.bottom; }
			if (right > target.right) { r = target.right; }
			set(l, t, r, b);
		}


		public double left   { get { return v1.x; } }
		public double top    { get { return v1.y; } }
		public double right  { get { return v2.x; } }
		public double bottom { get { return v2.y; } }
		public double width { get { return Math.abs(v1.x - v2.x); } }
		public double height { get { return Math.abs(v1.y - v2.y); } }
		public Point center {
			get { return new Point((left + right) / 2, (top + bottom) / 2); }
			set { centering(value); }
		}
		public double getLeft() { return left; }
		public double getTop() { return top; }
		public double getRight() { return right; }
		public double getBottom() { return bottom; }
		public double getWidth() { return width; }
		public double getHeight() { return height; }
		public Point getCenter() { return center; }



		public Color fill { get; set; }
		public Stroke stroke { get; set; }

		public override string ToString()
		{
			return "Left:" + left.ToString() + " Top:" + top.ToString() + " Right:" + right.ToString() + " Bottom:" + bottom.ToString();
		}
	}


	public partial class Ellipse : Shape
	{
		public Point datum { get; set; }
		public double xdiameter, ydiameter;

		//public static Ellipse[] this[int x] { get { return Array(x); } }
		//public static Ellipse[,] this[int x, int y] { get { return Array(x, y); } }
		public static Ellipse[] Array(int ind)
		{
			Ellipse[] l = new Ellipse[ind];
			for (int i = 0; i < ind; i++) { l[i] = new Ellipse(); }
			return l;
		}
		public static Ellipse[,] Array(int indx, int indy)
		{
			Ellipse[,] l = new Ellipse[indx, indy];
			for (int i = 0; i < indx; i++) { for (int j = 0; j < indy; j++) { l[i, j] = new Ellipse(); } }
			return l;
		}

		public Ellipse()
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			set(0,0);
		}
		public Ellipse(double wid, double hei)
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			set(wid, hei);
		}

		public Ellipse set(double wid, double hei)
		{
			xdiameter = wid;
			ydiameter = hei;
			return this;
		}
		public Ellipse resize(double width, double height)
		{
			Point po = center;
			set(width, height);
			centering(po);
			return this;
		}
		public Figure shift(Point p)
		{
			datum += p;
			return this;
		}
		public Figure centering(Point p)
		{
			datum = p;
			return this;
		}

		public virtual void draw()
		{
			Main.drawable.ellipse(this);
		}

		public double left { get { return datum.x - xdiameter/2.0; } }
		public double top { get { return datum.y - ydiameter / 2.0; } }
		public double right { get { return datum.x + xdiameter / 2.0; } }
		public double bottom { get { return datum.y + ydiameter / 2.0; } }
		public double width { get { return Math.abs(xdiameter); } }
		public double height { get { return Math.abs(ydiameter); } }
		public Point center
		{
			get { return new Point((left + right) / 2, (top + bottom) / 2); }
			set { centering(value); }
		}
		public double getLeft() { return left; }
		public double getTop() { return top; }
		public double getRight() { return right; }
		public double getBottom() { return bottom; }
		public double getWidth() { return width; }
		public double getHeight() { return height; }
		public Point getCenter() { return center; }

		public Color fill { get; set; }
		public Stroke stroke { get; set; }
	}


	public partial class Polygon : Shape
	{
		public Point datum { get; set; }
		public System.Collections.Generic.List<Point> vertices;

		public Polygon()
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			vertices = new System.Collections.Generic.List<Point>();
		}
		public Polygon(double[] verts)
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			vertices = new System.Collections.Generic.List<Point>();
			for (int i=0; i < verts.Length; i+=2)
			{
				vertices.Add(new Point(verts[i], verts[i+1]));
			}

		}
		public Polygon(Point[] verts)
		{
			fill = Color.white;
			stroke = Stroke.null_line;
			vertices = new System.Collections.Generic.List<Point>();
			foreach (Point p in verts)
			{
				vertices.Add(p);
			}

		}
		public Polygon append(Point p) { vertices.Add(p); return this; }
		public Polygon append(double x, double y) { return append(new Point(x, y, 0.0)); }
		public Polygon append(double x, double y, double z) { return append(new Point(x, y, z)); }


		public Figure shift(Point p)
		{
			datum = datum + p;
			return this;
		}
		public Figure centering(Point p)
		{
			datum = p;
			return this;
		}

		public virtual void draw()
		{
			Main.drawable.polygon(this);
		}

		public Color fill { get; set; }
		public Stroke stroke { get; set; }
	}

}