﻿using System;

namespace Psychlops
{

	public struct Clock
	{
		long ticks;
		// where ticks unit is 100 nano seconds.

		public void update()
		{
			ticks = DateTime.Now.Ticks;
		}
		public long at_msec()
		{
			return ticks/10000;
		}

		public static Clock operator +(Clock lhs, Clock rhs)
		{
			return new Clock { ticks = lhs.ticks + rhs.ticks };
		}
		public static Clock operator -(Clock lhs, Clock rhs)
		{
			return new Clock { ticks = lhs.ticks - rhs.ticks };
		}

		public static bool operator ==(Clock lhs, Clock rhs)
		{
			return lhs.ticks == rhs.ticks;
		}
		public static bool operator !=(Clock lhs, Clock rhs)
		{
			return lhs.ticks != rhs.ticks;
		}
		public override int GetHashCode()
		{
			return ticks.GetHashCode();
		}
		public static bool operator >(Clock lhs, Clock rhs)
		{
			return lhs.ticks > rhs.ticks;
		}
		public static bool operator <(Clock lhs, Clock rhs)
		{
			return lhs.ticks < rhs.ticks;
		}
		public static bool operator >=(Clock lhs, Clock rhs)
		{
			return lhs.ticks >= rhs.ticks;
		}
		public static bool operator <=(Clock lhs, Clock rhs)
		{
			return lhs.ticks <= rhs.ticks;
		}

		public override string ToString()
		{
			return ticks.ToString();
		}
	}

}
