package net.sf.amateras.nikocale.service;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.sf.nikonikofw.persistence.jdbc.JdbcUtil;
import jp.sf.nikonikofw.persistence.jdbc.annotation.Column;
import net.sf.amateras.nikocale.entity.Member;

public class MemberService {

	public static List<Member> getAllMembers() throws SQLException {
		return JdbcUtil.getResultList(Member.class,
				"SELECT * FROM MEMBER ORDER BY NAME ASC", new Object[0]);
	}

	public static List<Member> getMembers(Long groupId) throws SQLException {
		return JdbcUtil.getResultList(Member.class,
				"SELECT M.ID, M.NAME " +
				"FROM MEMBER M, GROUP_MEMBER GM "+
				"WHERE GM.GROUP_ID = ? AND GM.MEMBER_ID = M.ID " +
				"ORDER BY NAME ASC", groupId);
	}

	public static Member getMember(Long id) throws SQLException {
		return JdbcUtil.getSingleResult(Member.class,
				"SELECT * FROM MEMBER WHERE ID = ?", id);
	}

	public static void updateMember(Member member) throws SQLException {
		JdbcUtil.update(member);
	}

	public static Long addMember(Member member) throws SQLException {
		JdbcUtil.insert(member);

		LongValueBean record = JdbcUtil.getSingleResult(LongValueBean.class,
				"SELECT MAX(ID) AS VALUE FROM MEMBER", new Object[0]);
		return record.value;
	}

	public static void deleteMember(Member member) throws SQLException {
		JdbcUtil.execute("DELETE FROM ENTRY WHERE MEMBER_ID = ?", member.id);
		JdbcUtil.execute("DELETE FROM GROUP_MEMBER WHERE MEMBER_ID = ?", member.id);
		JdbcUtil.execute("DELETE FROM MEMBER WHERE ID = ?", member.id);
	}

	public static void updateGroupMember(Long memberId, List<Long> groupIds) throws SQLException {
		JdbcUtil.execute("DELETE FROM GROUP_MEMBER WHERE MEMBER_ID = ?", memberId);

		for(Long groupId: groupIds){
			JdbcUtil.execute("INSERT INTO GROUP_MEMBER (MEMBER_ID, GROUP_ID) VALUES (?, ?)",
					memberId, groupId);
		}
	}

	public static Map<Long, Boolean> getGroupMap(Long memberId) throws SQLException {
		List<LongValueBean> result = JdbcUtil.getResultList(LongValueBean.class,
				"SELECT GROUP_ID AS VALUE FROM GROUP_MEMBER WHERE MEMBER_ID = ?",
				memberId);

		Map<Long, Boolean> groupMap = new HashMap<Long, Boolean>();
		for(LongValueBean record: result){
			groupMap.put(record.value, true);
		}

		return groupMap;
	}

	public static class LongValueBean {
		@Column(name="VALUE")
		public Long value;
	}

}
