package net.sf.amateras.nikocale.action.admin;

import java.io.InputStream;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.persistence.jdbc.JdbcUtil;
import net.arnx.jsonic.JSON;
import net.sf.amateras.nikocale.action.admin.ExportAction.NikoCale;
import net.sf.amateras.nikocale.entity.Entry;
import net.sf.amateras.nikocale.entity.GroupCalendar;
import net.sf.amateras.nikocale.entity.GroupInfo;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.exception.ValidationException;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ImportAction implements IAction {
	
	@Request
	public String execute;
	
	@Request
	public String data;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		// インポート
		if(ServletFileUpload.isMultipartContent(request)){
			FileItemFactory factory = new DiskFileItemFactory();
			ServletFileUpload upload = new ServletFileUpload(factory);
			
			@SuppressWarnings("unchecked")
			List<FileItem> fileItemList = upload.parseRequest(request);
			
			for(FileItem item: fileItemList){
				if(item.getFieldName().equals("file")){
					InputStream in = item.getInputStream();
					try {
						String json = IOUtils.toString(in, "UTF-8");
						if(StringUtils.isNotEmpty(json)){
							importData(json);
						} else {
							throw new ValidationException("インポートするJSONファイルが指定されていません。");
						}
					} finally {
						in.close();
					}
				}
			}
			
			request.setAttribute("complete", "true");
		}
		
		request.setAttribute("title", "ニコカレデータのインポート");
		
		return "import.jsp";
	}
	
	private void importData(String json) throws Exception {
		NikoCale nikocale = JSON.decode(json, NikoCale.class);
		
		JdbcUtil.execute("DELETE FROM ENTRY", new Object[0]);
		JdbcUtil.execute("DELETE FROM GROUP_MEMBER", new Object[0]);
		JdbcUtil.execute("DELETE FROM GROUP_INFO", new Object[0]);
		JdbcUtil.execute("DELETE FROM MEMBER", new Object[0]);
		
		for(GroupInfo group: nikocale.groups){
			JdbcUtil.insert(group);
		}
		for(Member member: nikocale.members){
			JdbcUtil.insert(member);
			
			List<Long> groupIdList = nikocale.groupMember.get(member.id);
			if(groupIdList != null){
				for(Long groupId: groupIdList){
					JdbcUtil.execute(
							"INSERT INTO GROUP_MEMBER (MEMBER_ID, GROUP_ID) VALUES (?, ?)", 
							member.id, 
							groupId);
				}
			}
		}
		
		for(Entry entry: nikocale.entries){
			JdbcUtil.insert(entry);
		}
		
		for(GroupCalendar groupCalendar: nikocale.groupCalendar){
			JdbcUtil.insert(groupCalendar);
		}
		
		// TODO SystemInfoエンティティをエクスポートするようにしたので将来的には削除します
		JdbcUtil.execute("UPDATE SYSTEM_INFO SET INFORMATION = ?", nikocale.information);
		
		if(nikocale.systemInfo != null){
			JdbcUtil.update("DELETE FROM SYSTEM_INFO");
			JdbcUtil.insert(nikocale.systemInfo);
		}
	}

}
