package net.sf.amateras.nikocale.action.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.persistence.jdbc.JdbcUtil;
import net.arnx.jsonic.JSON;
import net.sf.amateras.nikocale.entity.Entry;
import net.sf.amateras.nikocale.entity.GroupCalendar;
import net.sf.amateras.nikocale.entity.GroupInfo;
import net.sf.amateras.nikocale.entity.GroupMember;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.entity.SystemInfo;
import net.sf.amateras.nikocale.service.SystemInfoService;

public class ExportAction implements IAction {

	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		NikoCale nikocale = new NikoCale();
		
		List<Member> members = JdbcUtil.getResultList(Member.class, "SELECT * FROM MEMBER");
		nikocale.members.addAll(members);
		
		List<GroupInfo> groups = JdbcUtil.getResultList(GroupInfo.class, "SELECT * FROM GROUP_INFO");
		nikocale.groups.addAll(groups);
		
		List<GroupMember> groupMembers = JdbcUtil.getResultList(GroupMember.class, "SELECT * FROM GROUP_MEMBER");
		for(GroupMember record: groupMembers){
			Long memberId = record.getMemberId();
			Long groupId = record.getGroupId();
			
			List<Long> list = nikocale.groupMember.get(memberId);
			if(list == null){
				list = new ArrayList<Long>();
				nikocale.groupMember.put(memberId, list);
			}
			
			list.add(groupId);
		}
		
		List<Entry> entries = JdbcUtil.getResultList(Entry.class, "SELECT * FROM ENTRY");
		nikocale.entries.addAll(entries);
		
		List<GroupCalendar> groupCalendar = JdbcUtil.getResultList(GroupCalendar.class, "SELECT * FROM GROUP_CALENDAR");
		nikocale.groupCalendar.addAll(groupCalendar);
		
		//nikocale.information = SystemInfoService.getInformation();
		nikocale.systemInfo = SystemInfoService.getSystemInfo();
		
		String json = JSON.encode(nikocale, true);
		response.setContentType("application/json; charset=UTF-8");
		response.setHeader("Content-Disposition", "attachment; filename=\"nikocale.json\"");
		response.getOutputStream().write(json.getBytes("UTF-8"));
		
		return null;
	}
	
	public static class NikoCale {
		public List<Member> members = new ArrayList<Member>();
		public List<GroupInfo> groups = new ArrayList<GroupInfo>();
		public List<Entry> entries = new ArrayList<Entry>();
		public List<GroupCalendar> groupCalendar = new ArrayList<GroupCalendar>();
		public Map<Long, List<Long>> groupMember = new HashMap<Long, List<Long>>();
		
		// TODO SystemInfoエンティティをエクスポートするようにしたので将来的には削除します
		@Deprecated
		public String information;
		
		public SystemInfo systemInfo;
	}

}
