package net.sf.amateras.nikocale.action;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import net.sf.amateras.nikocale.entity.Entry;
import net.sf.amateras.nikocale.entity.GroupInfo;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.exception.DataNotFoundException;
import net.sf.amateras.nikocale.service.EntryService;
import net.sf.amateras.nikocale.service.GroupService;
import net.sf.amateras.nikocale.service.MemberService;

public class RssAction implements IAction {
	
	@Request
	public Long groupId;
	
	@Request
	public Long memberId;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		// URLのプレフィックスを組み立て
		StringBuilder sb = new StringBuilder();
		sb.append(request.getScheme()).append("://");
		sb.append(request.getServerName());
		int port = request.getServerPort();
		if(port != 80){
			sb.append(":").append(port);
		}
		sb.append(request.getContextPath());
		request.setAttribute("url", sb.toString());
		
		if(groupId != null){
			// グループ別
			GroupInfo group = GroupService.getGroup(groupId);
			if(group == null){
				throw new DataNotFoundException("グループが存在しません。");
			}
			List<Entry> entries = EntryService.getRecentEntriesByGroup(groupId, 20);
			request.setAttribute("entries", entries);
			request.setAttribute("title", String.format("%sのニコニコカレンダー", group.groupName));
			
		} else if(memberId != null){
			// ユーザ別
			Member member = MemberService.getMember(memberId);
			if(member == null){
				throw new DataNotFoundException("ユーザが存在しません。");
			}
			List<Entry> entries = EntryService.getRecentEntriesByMember(memberId, 20);
			request.setAttribute("entries", entries);
			request.setAttribute("title", String.format("%sさんのニコニコカレンダー", member.name));
			
		} else {
			// 全体
			List<Entry> entries = EntryService.getRecentEntries(20);
			request.setAttribute("entries", entries);
			request.setAttribute("title", "ニコニコカレンダー");
		}
		
		return "rss.jsp";
	}

}
