package net.sf.amateras.nikocale.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.nikonikofw.action.IAction;
import jp.sf.nikonikofw.annotation.Request;
import jp.sf.nikonikofw.validation.Required;
import net.sf.amateras.nikocale.entity.Entry;
import net.sf.amateras.nikocale.entity.Member;
import net.sf.amateras.nikocale.exception.DataNotFoundException;
import net.sf.amateras.nikocale.service.EntryService;
import net.sf.amateras.nikocale.service.MemberService;

public class EditAction implements IAction {

	@Request
	@Required
	public Long memberId;
	
	@Request
	public Long groupId;
	
	@Request
	@Required
	public Integer year;
	
	@Request
	@Required
	public Integer month;
	
	@Request
	@Required
	public Integer day;
	
	@Request
	public String mode;
	
	@Override
	public String execute(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		
		request.setAttribute("year", year);
		request.setAttribute("month", month);
		request.setAttribute("day", day);
		request.setAttribute("groupId", groupId);
		
		Member member = MemberService.getMember(memberId);
		if(member == null){
			throw new DataNotFoundException("ユーザが存在しません。");
		}
		request.setAttribute("member", member);
		
		Entry entry = EntryService.getEntry(memberId, year, month, day);
		
		if(entry == null){
			entry = new Entry();
			entry.year = year;
			entry.month = month;
			entry.day = day;
			entry.status = 1;
			entry.message = "";
		}
		
		request.setAttribute("entry", entry);
		request.setAttribute("mode", mode);
		
		return "edit.jsp";
	}

}
