<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" isELIgnored="false"%>

<c:if test="${!empty recent && !empty top}">
  <div class="float_menu">
    <table cellspacing="0">
    <c:if test="${!empty recent}">
      <tr><th colspan="2" class="caption">最新のニコカレ</th></tr>
      <c:forEach items="${recent}" var="entry">
        <tr class="recent_border">
          <td colspan="2">
            <c:if test="${entry.status == 0}">
              <img src="images/good16.png">
            </c:if>
            <c:if test="${entry.status == 1}">
              <img src="images/normal16.png">
            </c:if>
            <c:if test="${entry.status == 2}">
              <img src="images/bad16.png">
            </c:if>
            <a href="entry.do?memberId=${entry.userId}&year=${entry.year}&month=${entry.month}&day=${entry.day}">${entry.year}年${entry.month}月${entry.day}日
            ${f:h(entry.memberName)}</a>
          </td>
        </tr>
        <tr>
          <td colspan="2" class="recent_message">
            <c:if test="${!empty entry.message}">
              <c:if test="${fn:length(entry.message) > 20}">
                ${f:h(fn:substring(entry.message, 0, 20))}...<br>
              </c:if>
              <c:if test="${fn:length(entry.message) <= 20}">
                ${f:h(entry.message)}<br>
              </c:if>
              <c:if test="${!empty entry.commentCount && entry.commentCount != 0}">
                <span style="color: red; font-size: 80%;">(${entry.commentCount}件のコメントがあります)</span>
              </c:if>
            </c:if>
          </td>
        </tr>
      </c:forEach>
    </c:if>
    <c:if test="${!empty top}">
      <tr><th colspan="2" class="caption"><img src="${context}/images/good16.png">&nbsp;ニコニコランキング</th></tr>
      <c:forEach items="${top}" var="member">
        <tr class="recent_border">
          <td><a href="member.do?memberId=${member.id}">${f:h(member.name)}</a></td>
          <td align="right">${member.point}pts</td>
        </tr>
      </c:forEach>
    </c:if>
    <c:if test="${!empty bottom}">
      <tr><th colspan="2" class="caption"><img src="${context}/images/bad16.png">&nbsp;ダメダメランキング</th></tr>
      <c:forEach items="${bottom}" var="member">
        <tr class="recent_border">
          <td><a href="member.do?memberId=${member.id}">${f:h(member.name)}</a></td>
          <td align="right">${member.point}pts</td>
        </tr>
      </c:forEach>
    </c:if>
    </table>
  </div>
</c:if>
