package jp.sf.nikonikofw.persistence;

import java.util.Properties;

import jp.sf.nikonikofw.exception.InitializeException;

/**
 * <code>IPersistenceManager</code>インターフェースの空実装です。
 * <p>
 * フレームワークの永続化サポートを使用しない場合、
 * <code>IPersistenceManager</code>の実装としてこのクラスが使用されます。
 * 
 * @author Naoki Takezoe
 */
public class NullPersistenceManager implements IPersistenceManager {

	/**
	 * このメソッドでは何も行いません。
	 */
	@Override
	public void begin() {
	}

	/**
	 * このメソッドでは何も行いません。
	 */
	@Override
	public void close() {
	}

	@Override
	public void commit() {
	}

	/**
	 * このメソッドでは何も行いません。
	 */
	@Override
	public void rollback() {
	}

	/**
	 * このメソッドでは何も行いません。
	 */
	@Override
	public void init(Properties props) throws InitializeException {
	}

}
