﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Twitter;
using WMPLib;

namespace Musitters
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            wmp.settings.autoStart = false;
            wmp.PlayStateChange += new _WMPOCXEvents_PlayStateChangeEventHandler(PlayStateChange);
            _form1Instance = this;

            var settings = Properties.Settings.Default;
            SetCurrentVersionRun();
            if (!string.IsNullOrEmpty((string)settings["AccessToken"]) && !string.IsNullOrEmpty((string)settings["MusicFolderPath"]))
            {
                ArrayList al = new ArrayList();
                this.GetAllFiles((string)settings["MusicFolderPath"], "*.mp3", ref al);
                this.GetAllFiles((string)settings["MusicFolderPath"], "*.wav", ref al);
                this.GetAllFiles((string)settings["MusicFolderPath"], "*.wma", ref al);
                this.musicFileList = al;
                this.ステータスToolStripMenuItem.Enabled = true;
            }
            else
            {
                form2 = new Form2();
                form2.Show();
            }

        }

        private Form2 form2;

        //Form1オブジェクトを保持するためのフィールド
        private static Form1 _form1Instance;

        //Form1オブジェクトを取得、設定するためのプロパティ
        public static Form1 Form1Instance
        {
            get
            {
                return _form1Instance;
            }
            set
            {
                _form1Instance = value;
            }
        }

        public WindowsMediaPlayer wmp = new WindowsMediaPlayer();
        private MusicFile mf;
        private ArrayList al = new ArrayList();
        private int nowPlayTimes = 1;
        private bool shouldPlay = false;

        public int NowPlayTimes
        {
            set { this.nowPlayTimes = value; }
            get { return this.nowPlayTimes; }
        }

        public ArrayList musicFileList
        {
            set { this.al = value; }
            get { return this.al; }
        }

        public void GetAllFiles(
            string folder, string searchPattern, ref ArrayList files)
        {
            //folderにあるファイルを取得する
            string[] fs =
                System.IO.Directory.GetFiles(folder, searchPattern);
            //ArrayListに追加する
            files.AddRange(fs);

            //folderのサブフォルダを取得する
            string[] ds = System.IO.Directory.GetDirectories(folder);
            //サブフォルダにあるファイルも調べる
            foreach (string d in ds)
                GetAllFiles(d, searchPattern, ref files);
        }

        public void PlayStateChange(int newState)
        {
            if (wmp.playState == WMPPlayState.wmppsMediaEnded)
            {
                this.shouldPlay = true;
            }
        }

        private void 設定ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            var settings = Properties.Settings.Default;
            form2 = new Form2();
            this.levelControl(settings.Level);
            form2.Show();
        }

        //フォームのCreateParamsプロパティをオーバーライドする
        protected override CreateParams CreateParams
        {
            [System.Security.Permissions.SecurityPermission(
                System.Security.Permissions.SecurityAction.LinkDemand,
                Flags = System.Security.Permissions.SecurityPermissionFlag.UnmanagedCode)]
            get
            {
                const int WS_EX_TOOLWINDOW = 0x80;
                const long WS_POPUP = 0x80000000L;
                const int WS_VISIBLE = 0x10000000;
                const int WS_SYSMENU = 0x80000;
                const int WS_MAXIMIZEBOX = 0x10000;

                CreateParams cp = base.CreateParams;
                cp.ExStyle = WS_EX_TOOLWINDOW;
                cp.Style = unchecked((int)WS_POPUP) |
                    WS_VISIBLE | WS_SYSMENU | WS_MAXIMIZEBOX;
                cp.Width = 0;
                cp.Height = 0;

                return cp;
            }
        }

        private void 再生ToolStripMenuItem_Click(object sender, EventArgs e)
        {

            if (wmp.playState == WMPPlayState.wmppsPaused)
            {
                wmp.controls.play();
            }
            else
            {
                randomMusicPlay();
            }
            this.再生ToolStripMenuItem.Visible = false;
            this.一時停止ToolStripMenuItem.Visible = true;
        }

        private void randomMusicPlay()
        {

            Random r = new Random();
            int nextMusicNum = r.Next(0, al.Count);

            wmp.URL = (string)al[nextMusicNum];
            this.mf = new MusicFile((string)al[nextMusicNum]);
            
            string tc;
            if (mf.Artist != "")
            {
                tc = mf.Title + " / " + mf.Artist;
            }
            else
            {
                tc = mf.Title;
            }

            try
            {
                if (102 < tc.Length)
                {
                    tweet(tc.Substring(0, 102) + "... #NowPlaying #musitters #" + "level" + this.nowPlayTimes);
                }
                else
                {
                    tweet(tc + " #NowPlaying #musitters #" + "level" + this.nowPlayTimes);
                }

                if (36 < mf.Title.Length)
                {

                    notifyIcon1.Text = mf.Title.Substring(0, 36) + "... - Now Playing Musitters";
                }
                else
                {
                    notifyIcon1.Text = mf.Title + " - Now Playing Musitters";
                }
            }
            catch (System.Net.WebException we)
            {
                this.nowPlayTimes += 1;
                //バルーンヒントのタイトル
                notifyIcon1.BalloonTipTitle = "ツイート失敗";
                //バルーンヒントに表示するメッセージ
                notifyIcon1.BalloonTipText = tc + " - Now Playing";
                if (36 < mf.Title.Length)
                {

                    notifyIcon1.Text = mf.Title.Substring(0, 36) + "... - Now Playing Musitters";
                }
                else
                {
                    notifyIcon1.Text = mf.Title + " - Now Playing Musitters";
                }
                //バルーンヒントに表示するアイコン
                notifyIcon1.BalloonTipIcon = ToolTipIcon.Info;
                //バルーンヒントを表示する
                //表示する時間をミリ秒で指定する
                notifyIcon1.ShowBalloonTip(1000);
                wmp.controls.play();
                return;
            }

            var settings = Properties.Settings.Default;

            if (settings.Level < this.nowPlayTimes)
            {
                settings.Level = this.nowPlayTimes;
                settings.Save();
            }

            //バルーンヒントのタイトル
            notifyIcon1.BalloonTipTitle = "ツイート完了 レベル" + this.nowPlayTimes + "になりました";
            //バルーンヒントに表示するメッセージ
            notifyIcon1.BalloonTipText = tc + " - Now Playing";
            //バルーンヒントに表示するアイコン
            notifyIcon1.BalloonTipIcon = ToolTipIcon.Info;
            //バルーンヒントを表示する
            //表示する時間をミリ秒で指定する
            notifyIcon1.ShowBalloonTip(1000);
            this.nowPlayTimes += 1;
            wmp.controls.play();
        }

        private void tweet(string text)
        {

            Dictionary<string, string> parameters = new Dictionary<string, string>();

            // 設定ファイルから読み込む
            var settings = Properties.Settings.Default;
            Auth auth = new Auth(settings.ConsumerKey, settings.ConsumerSecret,
                            settings.AccessToken, settings.AccessTokenSecret,
                            settings.UserId, settings.ScreenName);
            parameters.Add("status", auth.UrlEncode(text));
            auth.Post("http://api.twitter.com/1/statuses/update.xml", parameters);
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            // 設定ファイルから読み込む
            var settings = Properties.Settings.Default;
            if (!string.IsNullOrEmpty((string)settings["AccessToken"]) && !string.IsNullOrEmpty((string)settings["MusicFolderPath"]))
            {
                this.再生ToolStripMenuItem.Enabled = true;
            }
            else
            {
                this.再生ToolStripMenuItem.Enabled = false;
            }

            if (shouldPlay)
            {
                randomMusicPlay();
                if (wmp.playState == WMPPlayState.wmppsPlaying || wmp.playState == WMPPlayState.wmppsTransitioning)
                {
                    shouldPlay = false;
                }
            }
        }

        private void 終了ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            notifyIcon1.Visible = false;
            Application.Exit();
        }

        /**
         * CurrentUserのRunにアプリケーションの実行ファイルパスを登録する。
         */
        public static void SetCurrentVersionRun()
        {
            //Runキーを開く
            Microsoft.Win32.RegistryKey regkey =
                Microsoft.Win32.Registry.CurrentUser.OpenSubKey(
                @"Software\Microsoft\Windows\CurrentVersion\Run", true);
            //値の名前に製品名、値のデータに実行ファイルのパスを指定し、書き込む
            regkey.SetValue(Application.ProductName, Application.ExecutablePath);
            //閉じる
            regkey.Close();
        }

        /**
         * レベルに応じてフォームに変化を起こす。
         */
        private void levelControl(int level)
        {
            if (100 <= level)
            {
                form2.Size = new Size(508, 196);
                form2.webBrowser1.Visible = false;
            }
        }

        private void 一時停止ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            wmp.controls.pause();
            this.再生ToolStripMenuItem.Visible = true;
            this.一時停止ToolStripMenuItem.Visible = false;
        }

        private void ステータスToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Form4 form4 = new Form4();
            form4.Show();
        }

    }
}
