#!/bin/bash

#
# Hinemos Test Tool
#   試験項目エクスポート実行スクリプト
# 
# @version 1.2.0
# @since 1.0.0
#

# load Script Configuration
DIR=`dirname $0`
. ${DIR}/lib/hinemos_test_tool.cfg

# load Hinemos Manager Configuration
. ${HINEMOS_CFG}

HINEMOS_LIB=${HINEMOS_HOME}/lib

CLASSPATH=.:${DIR}
if [ ${HINEMOS_VERSION} = "3.0" ] ; then
	CLASSPATH=${CLASSPATH}:${DIR}/lib:${DIR}/lib/hinemos_test_tool.3.0.jar
elif [ ${HINEMOS_VERSION} = "3.1" ] ; then
	CLASSPATH=${CLASSPATH}:${DIR}/lib:${DIR}/lib/hinemos_test_tool.3.1.jar
elif [ ${HINEMOS_VERSION} = "3.2" ] ; then
	CLASSPATH=${CLASSPATH}:${DIR}/lib:${DIR}/lib/hinemos_test_tool.3.2.jar
else
	exit -1
fi

CLASSPATH=${CLASSPATH}:${DIR}/lib/jsch-0.1.42.jar

if [ ${HINEMOS_VERSION} = "3.0" ] || [ ${HINEMOS_VERSION} = "3.1" ] ; then
	CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/AccessControlEJB.jar:${JBOSS_DEPLOY}/NotifyEJB.jar
    CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/PingEJB.jar:${JBOSS_DEPLOY}/HttpEJB.jar
    CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/HinemosAgentEJB.jar:${JBOSS_DEPLOY}/ProcessEJB.jar
    CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/PerformanceEJB.jar:${JBOSS_DEPLOY}/PortEJB.jar
    CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/SnmpEJB.jar:${JBOSS_DEPLOY}/SqlEJB.jar
    CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/SnmpTrapEJB.jar:${JBOSS_DEPLOY}/SyslogNGEJB.jar
    CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/MaintenanceEJB.jar:${JBOSS_DEPLOY}/LogTransferEJB.jar
    CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/RepositoryEJB.jar:${JBOSS_DEPLOY}/JobManagementEJB.jar
    CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/CalendarEJB.jar:${JBOSS_DEPLOY}/MonitorEJB.jar
    CLASSPATH=${CLASSPATH}:${JBOSS_LIB}/quartz.jar:${JBOSS_LIB}/org.eclipse.jface_3.1.1.jar
elif [ ${HINEMOS_VERSION} = "3.2" ] ; then
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/HinemosCommon.jar:${HINEMOS_LIB}/HinemosIF.jar
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/quartz.jar:${HINEMOS_LIB}/org.eclipse.jface_3.1.1.jar
fi

CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/jbossall-client.jar:${HINEMOS_LIB}/commons-logging-1.1.jar

LOG4J=`find ${HINEMOS_LIB}/log4j-*.jar -printf %f`
CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/${LOG4J}


${JAVA_HOME}/bin/java ${OPT} -Dlogdir=${DIR} -classpath ${CLASSPATH} jp.co.intellilink.hinemos.test.ExportTestCase $* 2>/dev/null
RET=$?

#echo ${RET}
exit ${RET}