#!/bin/bash

# 
# Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# Hinemos Tools
#
# Hinemos JMX Tool
#   JMX情報取得ツール起動スクリプト
# 
# @version 1.0.0
# @since 1.0.0
#

# load Script Configuration
DIR=`dirname $0`
. ${DIR}/lib/hinemos_tools.cfg

# load Hinemos Manager Configuration
. ${HINEMOS_CFG}

if [ -f $HINEMOS_JMX_TOOL_PID ] ; then
	read JMX_TOOL_PID < $HINEMOS_JMX_TOOL_PID
	ps -p $JMX_TOOL_PID -f | grep JMXTool > /dev/null && TMP=1
	if [ "$TMP" ] ; then
	        echo "JMXTool already started!"
        	exit 1
	fi
fi

JBOSS_LIB=${JBOSS_HOME}/server/default/lib
HINEMOS_LIB=${HINEMOS_HOME}/lib

CLASSPATH=.:${DIR}
if [ ${HINEMOS_VERSION} = "3.0" ] ; then
	CLASSPATH=${CLASSPATH}:${DIR}/lib:${DIR}/lib/hinemos_tools.3.0.jar
elif [ ${HINEMOS_VERSION} = "3.1" ] ; then
	CLASSPATH=${CLASSPATH}:${DIR}/lib:${DIR}/lib/hinemos_tools.3.1.jar
elif [ ${HINEMOS_VERSION} = "3.2" ] ; then
	CLASSPATH=${CLASSPATH}:${DIR}/lib:${DIR}/lib/hinemos_tools.3.2.jar
else
	exit -1
fi

if [ ${HINEMOS_VERSION} = "3.0" ] || [ ${HINEMOS_VERSION} = "3.1" ] ; then
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/AccessControlEJB.jar:${HINEMOS_LIB}/clustercontrol.jar
elif [ ${HINEMOS_VERSION} = "3.2" ] ; then
	CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/HinemosCommon.jar:${HINEMOS_LIB}/HinemosIF.jar
fi

CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/jbossall-client.jar:${HINEMOS_LIB}/commons-logging-1.1.jar

LOG4J=`find ${HINEMOS_LIB}/log4j-*.jar -printf %f`
CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/${LOG4J}

${JAVA_HOME}/bin/java ${OPT} -Dlogdir=${DIR} -classpath ${CLASSPATH} jp.co.intellilink.hinemos.jmx.JMXTool $* 2>/dev/null &
RET=$?

echo $! > $HINEMOS_JMX_TOOL_PID  
echo "JMXTool started"