/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.test.util;

import java.util.List;

import com.clustercontrol.bean.DayOfWeekConstant;


/**
 * 2次元配列のデータ(曜日)をソートするクラス<BR>
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class DayOfWeekListComparator implements java.util.Comparator{
	private int index = 0;
	
	public DayOfWeekListComparator(int index){
		this.index = index;
	}
	
	/* (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2){
		if (o1 instanceof List && o2 instanceof List) {
			Integer value1 = DayOfWeekConstant.stringToType((String)((List)o1).get(index));
			Integer value2 = DayOfWeekConstant.stringToType((String)((List)o2).get(index));
			return value1.compareTo(value2);
		}
		else
			return 0;
	}
}

