/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.test.monitor.syslogng;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

import jp.co.intellilink.hinemos.test.monitor.ExportTestCaseMonitor;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.ejb.session.SyslogNGController;

/**
 * Syslog-ng監視情報を基に試験項目のCSVフォーマット文字列を作成するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportTestCaseMonitorSyslogng extends ExportTestCaseMonitor {

	// ログ出力
	private static Log log = LogFactory.getLog(ExportTestCaseMonitorSyslogng.class);

	/**
     * Syslog-ng監視情報を基に試験項目のCSVフォーマット文字列を作成する。<br>
     */
    public void exportTestCase() {
    	log.info("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.Syslogng.Start"));
    	
    	//CSV出力配列を用意
    	ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
    	
    	//監視項目リスト取得
    	ArrayList<LogFilterInfo> infoList = getSyslogngList();
    	
    	if(infoList instanceof ArrayList){
			for(LogFilterInfo info : infoList){
				Object[] args = {info.getMonitorId()};
				log.info("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.MonitorID", args));
				
				csvOutput.addAll(createTestCase(info));
			}
			
			//ファシリティIDでソート
			Collections.sort(csvOutput, new StringListComparator(1));
			//監視項目IDでソート
			Collections.sort(csvOutput, new StringListComparator(0));
    	}
    	 	
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
		
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Testcase.Output.Dir") + "/SYSLOGNG_" + format.format(new Date()) + ".csv", 
				csvOutput);
		
		log.info("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.Syslogng.End"));
    }
    
    /* (non-Javadoc)
     * @see jp.co.intellilink.hinemos.test.monitor.TestMonitor#getFacilityIdList(com.clustercontrol.monitor.run.bean.MonitorInfo)
     */
    @Override
	protected ArrayList<String> getFacilityIdList(MonitorInfo monitorInfo) {
		ArrayList<String> facilityIdList = new ArrayList<String>();
		
        //監視結果のファシリティIDリストを取得
		facilityIdList.addAll(getNodeList(monitorInfo.getFacilityId()));
		
		return facilityIdList;
	}

	/**
     * 監視項目リストを取得する。<br>
     * 
     * @return 監視項目一覧
     */
    protected ArrayList<LogFilterInfo> getSyslogngList() {

    	SyslogNGController syslog = EjbConnectionManager.getConnectionManager().getMonitorSyslogNGController();

    	ArrayList<LogFilterInfo> records = null;
    	try {
    		records = syslog.getFilterInfoList();
        } catch (Exception e) {
			log.error("[" + Messages.getMsg("ExportTestCase")+ "] " + Messages.getMsg("TestTool.ConnectManagerFailed"), e);
			System.exit(14);
        }
        return records;
    }
}