#!/bin/bash

#
# Hinemos Test Tool
#   監視結果チェック実行スクリプト
# 
# @version 1.0.0
# @since 1.0.0
#

# load Script Configuration
DIR=`dirname $0`
. ${DIR}/lib/hinemos_test_tool.cfg

# load Hinemos Manager Configuration
. ${HINEMOS_CFG}

JBOSS_DEPLOY=${JBOSS_HOME}/server/default/deploy
JBOSS_LIB=${JBOSS_HOME}/server/default/lib
HINEMOS_LIB=${HINEMOS_HOME}/lib

CLASSPATH=.:${DIR}:${DIR}/lib:${DIR}/lib/hinemos_test_tool.jar

CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/AccessControlEJB.jar:${JBOSS_DEPLOY}/NotifyEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/PingEJB.jar:${JBOSS_DEPLOY}/HttpEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/HinemosAgentEJB.jar:${JBOSS_DEPLOY}/ProcessEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/PerformanceEJB.jar:${JBOSS_DEPLOY}/PortEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/SnmpEJB.jar:${JBOSS_DEPLOY}/SqlEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/SnmpTrapEJB.jar:${JBOSS_DEPLOY}/SyslogNGEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/MaintenanceEJB.jar:${JBOSS_DEPLOY}/LogTransferEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/RepositoryEJB.jar:${JBOSS_DEPLOY}/JobManagementEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/CalendarEJB.jar:${JBOSS_DEPLOY}/MonitorEJB.jar

CLASSPATH=${CLASSPATH}:${JBOSS_LIB}/quartz.jar:${JBOSS_LIB}/org.eclipse.jface_3.1.1.jar

CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/hinemos-commons.jar:${HINEMOS_LIB}/clustercontrol.jar
CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/jbossall-client.jar:${HINEMOS_LIB}/log4j-1.2.14.jar:
CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/commons-logging-1.1.jar

${JAVA_HOME}/bin/java ${OPT} -Dlogdir=${DIR} -classpath ${CLASSPATH} jp.co.intellilink.hinemos.test.CheckResult $* 2>/dev/null
RET=$?

#echo ${RET}
exit ${RET}