/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.operation.logger;

import org.jboss.aop.Aspect;
import org.jboss.aop.Bind;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.MethodInvocation;

import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;

/**
 * SNMPTRAPユーティリティ機能 操作ログ出力クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 * @see jp.co.intellilink.operation.logger.Logger
 */
@Aspect (scope= Scope.PER_VM)
public class SnmpTrap extends Logger {

	/**
	 * MIBマスタ追加時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerBean->addMibMaster(..))")
	public Object addMibMasterAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Snmptrap] Add MIB";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof SnmpTrapMibMasterData){
			SnmpTrapMibMasterData data = (SnmpTrapMibMasterData)args[0];
			msg.append(", MIB=");
			msg.append(data.getMib());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * OIDマスタ追加時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerBean->addOidMaster(..))")
	public Object addOidMasterAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Snmptrap] Add OID";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof SnmpTrapMasterInfo){
			SnmpTrapMasterInfo info = (SnmpTrapMasterInfo)args[0];
			msg.append(", MIB=");
			msg.append(info.getMib());
			msg.append(", Trap=");
			msg.append(info.getUei());
			msg.append(", OID=");
			msg.append(info.getTrapOid());
			msg.append(", GenericID=");
			msg.append(info.getGenericId());
			msg.append(", SpecificID=");
			msg.append(info.getSpecificId());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * MIBマスタ変更時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerBean->modifyMibMaster(..))")
	public Object modifyMibMasterAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Snmptrap] Change MIB";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof SnmpTrapMibMasterData){
			SnmpTrapMibMasterData data = (SnmpTrapMibMasterData)args[0];
			msg.append(", MIB=");
			msg.append(data.getMib());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * OIDマスタ変更時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerBean->modifyOidMaster(..))")
	public Object modifyOidMasterAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Snmptrap] Change OID";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof SnmpTrapMasterInfo){
			SnmpTrapMasterInfo info = (SnmpTrapMasterInfo)args[0];
			msg.append(", MIB=");
			msg.append(info.getMib());
			msg.append(", Trap=");
			msg.append(info.getUei());
			msg.append(", OID=");
			msg.append(info.getTrapOid());
			msg.append(", GenericID=");
			msg.append(info.getGenericId());
			msg.append(", SpecificID=");
			msg.append(info.getSpecificId());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * MIBマスタ削除時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerBean->deleteMibMaster(..))")
	public Object deleteMibMasterAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Snmptrap] Delete MIB";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof String){
			msg.append(", MIB=");
			msg.append((String)args[0]);
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}

	/**
	 * OIDマスタ削除時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.snmptrap.ejb.session.MonitorSnmpTrapControllerBean->deleteOidMaster(..))")
	public Object deleteOidMasterAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Snmptrap] Delete OID";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof SnmpTrapMasterInfo){
			SnmpTrapMasterInfo info = (SnmpTrapMasterInfo)args[0];
			msg.append(", MIB=");
			msg.append(info.getMib());
			msg.append(", Trap=");
			msg.append(info.getUei());
			msg.append(", OID=");
			msg.append(info.getTrapOid());
			msg.append(", GenericID=");
			msg.append(info.getGenericId());
			msg.append(", SpecificID=");
			msg.append(info.getSpecificId());
		}

		outputLogMessage(title, msg.toString(), invocation);

		return result;
	}
}
