/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.operation.logger;

import org.jboss.aop.Aspect;
import org.jboss.aop.Bind;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.MethodInvocation;

import com.clustercontrol.performance.bean.CollectorProperty;

/**
 * 性能管理機能 操作ログ出力クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 * @see jp.co.intellilink.operation.logger.Logger
 */
@Aspect (scope= Scope.PER_VM)
public class Performance extends Logger {

	/**
	 * 収集設定登録時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.performance.ejb.session.CollectorControllerBean->createRecordColletor(..))")
	public Object createRecordColletorAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Performance] Create";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof CollectorProperty){
			CollectorProperty collectorDef = (CollectorProperty)args[0];
			msg.append(", CollectorID=");
			msg.append(collectorDef.getCollectorData().getCollectorID());
		}

		outputLogMessage(title.toString(), msg.toString(), invocation);

		return result;
	}

	/**
	 * 収集停止時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.performance.ejb.session.CollectorControllerBean->stopRecordCollector(..))")
	public Object stopRecordCollectorAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Performance] Stop";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof String){
			msg.append(", CollectorID=");
			msg.append((String)args[0]);
		}

		outputLogMessage(title.toString(), msg.toString(), invocation);

		return result;
	}

	/**
	 * 収集設定削除時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.performance.ejb.session.CollectorControllerBean->deleteRecordCollector(..))")
	public Object deleteRecordCollectorAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Performance] Delete";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof String){
			msg.append(", CollectorID=");
			msg.append((String)args[0]);
		}

		outputLogMessage(title.toString(), msg.toString(), invocation);

		return result;
	}
}
