/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.operation.logger;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.jboss.aop.Aspect;
import org.jboss.aop.Bind;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.joinpoint.MethodInvocation;

import com.clustercontrol.bean.ConfirmConstant;
import com.clustercontrol.bean.FacilityTargetConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.bean.StatusInfoData;
import com.clustercontrol.monitor.factory.EventFilterProperty;
import com.clustercontrol.monitor.factory.StatusFilterProperty;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogData;
import com.clustercontrol.util.PropertyUtil;

/**
 * 監視管理機能 操作ログ出力クラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 * @see jp.co.intellilink.operation.logger.Logger
 */
@Aspect (scope= Scope.PER_VM)
public class Monitor extends Logger {

	/**
	 * ステータス削除時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public boolean com.clustercontrol.monitor.ejb.session.MonitorControllerBean->deleteStatus(..))")
	public Object deleteStatusAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Monitor] Delete Status";
		StringBuffer msg = new StringBuffer();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		if(args.length > 0 && args[0] instanceof List){
			int i = 1;
			for (StatusInfoData status : (List<StatusInfoData>)args[0]) {
				msg.append(", " + i + "=(");
				msg.append("PluginID=");
				msg.append(status.getPluginId());
				msg.append(", MonitorID=");
				msg.append(status.getMonitorId());
				msg.append(", FacilityID=");
				msg.append(status.getFacilityId());
				msg.append(")");
				i++;
			}
		}

		outputLogMessage(title.toString(), msg.toString(), invocation);

		return result;
	}

	/**
	 * イベント確認時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.monitor.ejb.session.MonitorControllerBean->modifyConfirm(*.List, int))")
	public Object modifyConfirmAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Monitor] Confirm";
		StringBuffer msg = new StringBuffer();

		DateFormat format = DateFormat.getDateTimeInstance();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		int confirmType = (Integer)args[1];
		if(args[0] instanceof List){
			int i = 1;
			for (EventLogData event : (List<EventLogData>)args[0]) {
				msg.append(", " + i + "=(");
				msg.append("PluginID=");
				msg.append(event.getPluginId());
				msg.append(", FacilityID=");
				msg.append(event.getFacilityId());
				msg.append(", Priority=");
				msg.append(PriorityConstant.typeToStringEN(event.getPriority()));
				msg.append(", Time Received=");
				msg.append(format.format(event.getOutputDate()));
				msg.append(", Time Created=");
				msg.append(format.format(event.getGenerationDate()));
				msg.append(", Comfirm=");
				if(confirmType == ConfirmConstant.TYPE_CONFIRMED)
					msg.append("Confirmed");
				else
					msg.append("Unonfirmed");
				msg.append(")");
				i++;
			}
		}

		outputLogMessage(title.toString(), msg.toString(), invocation);

		return result;
	}

	/**
	 * イベント一括確認時のログ出力
	 * 
	 * @param invocation 
	 * @return invokeNext()の結果
	 * @throws Throwable
	 */
	@Bind (pointcut="execution(public void com.clustercontrol.monitor.ejb.session.MonitorControllerBean->modifyBatchConfirm(..))")
	public Object modifyBatchConfirmAdvice(MethodInvocation invocation) throws Throwable {
		Object result = invocation.invokeNext();

		String title = "[Monitor] Confirm All";
		StringBuffer msg = new StringBuffer();

		DateFormat format = DateFormat.getDateTimeInstance();

		Object[] args = ((MethodInvocation)invocation).getArguments();
		int confirmType = (Integer)args[0];
		if(args.length > 1 && args[1] instanceof String){
			msg.append(", FacilityID=");
			msg.append((String)args[1]);
		}
		if(args.length > 2 && args[2] instanceof Property){
			ArrayList values = PropertyUtil.getPropertyValue((Property)args[2], EventFilterProperty.PRIORITY);
			msg.append(", Priority=");
			int priority = PriorityConstant.stringToType((String)values.get(0));
			msg.append(PriorityConstant.typeToStringEN(priority));

			values = PropertyUtil.getPropertyValue((Property)args[2], EventFilterProperty.OUTPUT_FROM_DATE);
			if(values.get(0) instanceof Date){
				msg.append(", Time Received(Start)=");
				Timestamp time = new Timestamp(((Date)values.get(0)).getTime());
				time.setNanos(0);
				msg.append(format.format(new Date(time.getTime())));
			}

			values = PropertyUtil.getPropertyValue((Property)args[2], EventFilterProperty.OUTPUT_TO_DATE);
			if(values.get(0) instanceof Date){
				msg.append(", Time Received(End)=");
				Timestamp time = new Timestamp(((Date)values.get(0)).getTime());
				time.setNanos(0);
				msg.append(format.format(new Date(time.getTime())));
			}

			values = PropertyUtil.getPropertyValue((Property)args[2], EventFilterProperty.GENERATION_FROM_DATE);
			if(values.get(0) instanceof Date){
				msg.append(", Time Created(Start)=");
				Timestamp time = new Timestamp(((Date)values.get(0)).getTime());
				time.setNanos(0);
				msg.append(format.format(new Date(time.getTime())));
			}

			values = PropertyUtil.getPropertyValue((Property)args[2], EventFilterProperty.GENERATION_TO_DATE);
			if(values.get(0) instanceof Date){
				msg.append(", Time Created(End)=");
				Timestamp time = new Timestamp(((Date)values.get(0)).getTime());
				time.setNanos(0);
				msg.append(format.format(new Date(time.getTime())));
			}

			values = PropertyUtil.getPropertyValue((Property)args[2], StatusFilterProperty.FACILITY_TYPE);
			if(values.get(0) instanceof String){
				msg.append(", Target Facility=");
				if(FacilityTargetConstant.STRING_BENEATH.equals((String)values.get(0)))
					msg.append("Sub-scope Facilities Only");
				else
					msg.append("ALL Facilities");
			}

			values = PropertyUtil.getPropertyValue((Property)args[2], StatusFilterProperty.APPLICATION);
			if(values.get(0) instanceof String){
				msg.append(", Application=");
				msg.append((String)values.get(0));
			}

			values = PropertyUtil.getPropertyValue((Property)args[2], StatusFilterProperty.MESSAGE);
			if(values.get(0) instanceof String){
				msg.append(", Message=");
				msg.append((String)values.get(0));
			}
		}

		outputLogMessage(title.toString(), msg.toString(), invocation);

		return result;
	}
}
