/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.operation.logger.util;

import org.jboss.aop.joinpoint.MethodInvocation;

/**
 * ログメッセージ生成Decoratorクラス
 * 
 * @since 1.0.0
 * @version 1.0.0
 */
public abstract class LogMessageDecorator extends LogMessageComponent {
	protected LogMessageComponent component = null;

	/**
	 * コンストラクタ
	 * 
	 * @param component Componentオブジェクト
	 */
	public LogMessageDecorator(LogMessageComponent component){
		this.component = component;
	}

	/* (non-Javadoc)
	 * @see jp.co.intellilink.operation.logger.util.LogMessageComponent#getLogMessage()
	 */
	@Override
	public String getLogMessage() throws Exception {
		return component.getLogMessage();
	}

	/* (non-Javadoc)
	 * @see jp.co.intellilink.operation.logger.util.LogMessageComponent#getValue()
	 */
	@Override
	public MethodInvocation getValue() {
		return component.getValue();
	}

	/* (non-Javadoc)
	 * @see jp.co.intellilink.operation.logger.util.LogMessageComponent#setValue(org.jboss.aop.joinpoint.MethodInvocation)
	 */
	@Override
	public void setValue(MethodInvocation invocation) {
		component.setValue(invocation);
	}
}
