/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.job;

import java.util.Locale;

import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.bean.JobInfo;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;

/**
 * ジョブ管理情報を削除するクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class DeleteJob {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteJob.class);

	/**
	 * ジョブ管理情報を削除する。<br>
	 */
	public void delete() {
		log.info(Messages.getMsg("ImportTool.Job.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//ジョブツリー作成
		JobTreeItem treeItem = createJobTree();

		//ジョブ削除
		registerJob(treeItem);

		log.info(Messages.getMsg("ImportTool.Job.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * ジョブツリー作成<br>
	 * 
	 * @return ジョブツリー
	 */
	public JobTreeItem createJobTree() {

		//JobTreeItemの最上位インスタンスを作成
		JobInfo info = new JobInfo("", JobConstant.STRING_COMPOSITE, JobConstant.TYPE_COMPOSITE);
		JobTreeItem tree = new JobTreeItem(null, info);

		//ジョブツリーのルートを生成
		info = new JobInfo("", com.clustercontrol.util.Messages.getString("job", Locale.getDefault()), JobConstant.TYPE_COMPOSITE);
		new JobTreeItem(tree, info);

		return tree;
	}

	/**
	 * ジョブツリーを登録する。<br>
	 * 
	 * @param item ジョブツリー
	 */
	protected void registerJob(JobTreeItem item) {
		log.info(Messages.getMsg("ImportTool.Job.Register.Start"));

		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();

		try {
			job.registerJob(item);
		} catch (Exception e) {
			log.error(Messages.getMsg("ExportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}

		log.info(Messages.getMsg("ImportTool.Job.Register.End"));
	}
}