/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.process.ejb.session.MonitorProcessController;

/**
 * プロセス監視情報を削除するクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class DeleteMonitorProcess {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteMonitorProcess.class);

	/**
	 * プロセス監視情報を削除する<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("ImportTool.Process.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//監視項目リスト取得
		ArrayList idList = getMonitorList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				deleteMonitorInfo((String)line.get(0));
			}
		}

		log.info(Messages.getMsg("ImportTool.Process.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * 監視情報を削除する。<br>
	 * 
	 * @param monitorId 監視項目ID
	 */
	protected void deleteMonitorInfo(String monitorId) {
		MonitorProcessController process = EjbConnectionManager.getConnectionManager().getMonitorProcessController();

		try {
			Object[] args = {monitorId};
			log.info(Messages.getMsg("ImportTool.MonitorID", args) + 
					" (" + Messages.getMsg("delete") + ")");

			process.deleteProcess(monitorId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorProcessController process = EjbConnectionManager.getConnectionManager().getMonitorProcessController();

		ArrayList records = null;
		try {
			records = process.getProcessList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}