/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;

/**
 * SQL監視情報の有効・無効を設定するクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class ChangeValidMonitorSql {

	// ログ出力
	private static Log log = LogFactory.getLog(ChangeValidMonitorSql.class);

	/**
	 * SQL監視情報の有効・無効を設定する<br>
	 * 
	 * @param valid 有効/無効
	 */
	@SuppressWarnings("unchecked")
	public void changeValid(boolean valid) {
		log.info(Messages.getMsg("ImportTool.Sql.Start", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));

		//監視項目リスト取得
		ArrayList idList = getMonitorList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				int monitorType = MonitorTypeConstant.stringToType((String)line.get(3));
				MonitorInfo info = getSql((String)line.get(0), monitorType);
				info.setValid(ValidConstant.booleanToType(valid));
				changeMonitorInfo(info);
			}
		}

		log.info(Messages.getMsg("ImportTool.Sql.End", new String[]{Messages.getMsg("ImportTool.Change.Valid")}));
	}

	/**
	 * 監視情報の有効・無効を変更する。<br>
	 * 
	 * @param info 監視情報オブジェクト
	 */
	protected void changeMonitorInfo(MonitorInfo info) {
		MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getMonitorSqlController();

		try {
			Object[] args = {info.getMonitorId()};
			log.info(Messages.getMsg("ImportTool.MonitorID", args) + 
					" (" + Messages.getMsg("modify") + ")");

			sql.modifySql(info);
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * SQL監視情報を取得する。<br>
	 * 
	 * @param monitorId 取得対象の監視項目ID
	 * @return SQL監視情報
	 */
	protected MonitorInfo getSql(String monitorId, int monitorType) {

		MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getMonitorSqlController();

		MonitorInfo info = null;
		try {
			info = sql.getSqlInfo(monitorId, monitorType);
		} catch (Exception e) {
			log.error(Messages.getMsg("ExportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return info;
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorSqlController sql = EjbConnectionManager.getConnectionManager().getMonitorSqlController();

		ArrayList records = null;
		try {
			records = sql.getSqlList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}