/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.job;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.ejb.session.JobController;

/**
 * スケジュール情報を削除するクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class DeleteSchedule {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteSchedule.class);

	/**
	 * スケジュール情報を削除する<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("ImportTool.Job.Schedule.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//監視項目リスト取得
		ArrayList idList = getScheduleList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				deleteSchedule((String)line.get(0));
			}
		}

		log.info(Messages.getMsg("ImportTool.Job.Schedule.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * スケジュールを削除する。<br>
	 * 
	 * @param scheduleId スケジュールID
	 */
	protected void deleteSchedule(String scheduleId) {

		JobController job = EjbConnectionManager.getConnectionManager().getJobController();

		try {
			Object[] args = {scheduleId};
			log.info(Messages.getMsg("ImportTool.ScheduleID", args) + 
					" (" + Messages.getMsg("delete") + ")");

			job.deleteSchedule(scheduleId);
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * スケジュール一覧を取得する。<br>
	 * 
	 * @return スケジュール一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getScheduleList() {

		JobController job = EjbConnectionManager.getConnectionManager().getJobController();

		ArrayList list = null;
		try {
			list = job.getScheduleList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}
		return list;
	}
}