/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool;

import java.util.Arrays;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.importtool.conf.access.DeleteAccess;
import jp.co.intellilink.hinemos.importtool.conf.calendar.DeleteCalendar;
import jp.co.intellilink.hinemos.importtool.conf.job.DeleteJob;
import jp.co.intellilink.hinemos.importtool.conf.job.DeleteSchedule;
import jp.co.intellilink.hinemos.importtool.conf.logtransfer.DeleteLogTransfer;
import jp.co.intellilink.hinemos.importtool.conf.maintenance.DeleteMaintenance;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorAgent;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorHttp;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorPerformance;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorPing;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorPort;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorProcess;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorSnmp;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorSnmpTrap;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorSql;
import jp.co.intellilink.hinemos.importtool.conf.monitor.DeleteMonitorSyslogng;
import jp.co.intellilink.hinemos.importtool.conf.notify.DeleteMailTemplate;
import jp.co.intellilink.hinemos.importtool.conf.notify.DeleteNotify;
import jp.co.intellilink.hinemos.importtool.conf.repository.DeleteNode;
import jp.co.intellilink.hinemos.importtool.conf.repository.DeleteScope;
import jp.co.intellilink.hinemos.importtool.util.LoginManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * DeleteConf メインクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class DeleteConf {
	// main関数に与えられる引数
	private static String mode = "all";

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteConf.class);

	/**
	 * メイン
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		// 実行ログを記載
		log.info(Messages.getMsg("ImportTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		if (args.length > 1) {
			log.error(Messages.getMsg("ImportTool.ArgsInvalid"));
			System.exit(11);
		}

		// 引数の格納
		if(args.length == 0 || args[0].equals(""))
			mode = "all";
		else if(args.length == 1)
			mode = args[0];

		if(mode.equalsIgnoreCase("agent") || mode.equalsIgnoreCase("all")){
			//エージェント監視
			DeleteMonitorAgent agent = new DeleteMonitorAgent();
			agent.delete();
		}
		if(mode.equalsIgnoreCase("http") || mode.equalsIgnoreCase("all")){
			//HTTP監視
			DeleteMonitorHttp http = new DeleteMonitorHttp();
			http.delete();
		}
		if(mode.equalsIgnoreCase("ping") || mode.equalsIgnoreCase("all")){
			//Ping監視
			DeleteMonitorPing ping = new DeleteMonitorPing();
			ping.delete();
		}
		if(mode.equalsIgnoreCase("port") || mode.equalsIgnoreCase("all")){
			//サービス・ポート監視
			DeleteMonitorPort port = new DeleteMonitorPort();
			port.delete();
		}
		if(mode.equalsIgnoreCase("process") || mode.equalsIgnoreCase("all")){
			//プロセス監視
			DeleteMonitorProcess process = new DeleteMonitorProcess();
			process.delete();
		}
		if(mode.equalsIgnoreCase("resource") || mode.equalsIgnoreCase("all")){
			//リソース監視
			DeleteMonitorPerformance perf = new DeleteMonitorPerformance();
			perf.delete();
		}
		if(mode.equalsIgnoreCase("mainte") || mode.equalsIgnoreCase("all")){
			//メンテナンス
			DeleteMaintenance maintenance = new DeleteMaintenance();
			maintenance.delete();
		}
		if(mode.equalsIgnoreCase("sql") || mode.equalsIgnoreCase("all")){
			//SQL監視
			DeleteMonitorSql sql = new DeleteMonitorSql();
			sql.delete();
		}
		if(mode.equalsIgnoreCase("snmp") || mode.equalsIgnoreCase("all")){
			//SNMP監視
			DeleteMonitorSnmp snmp = new DeleteMonitorSnmp();
			snmp.delete();
		}
		if(mode.equalsIgnoreCase("trap") || mode.equalsIgnoreCase("all")){
			//SNMPTRAP監視
			DeleteMonitorSnmpTrap trap = new DeleteMonitorSnmpTrap();
			trap.delete();
		}
		if(mode.equalsIgnoreCase("syslog") || mode.equalsIgnoreCase("all")){
			//Syslog-ng監視
			DeleteMonitorSyslogng syslogng = new DeleteMonitorSyslogng();
			syslogng.delete();
		}
		if(mode.equalsIgnoreCase("log") || mode.equalsIgnoreCase("all")){
			//ログ転送
			DeleteLogTransfer log = new DeleteLogTransfer();
			log.delete();
		}
		if(mode.equalsIgnoreCase("sche") || mode.equalsIgnoreCase("all")){
			//ジョブスケジュール
			DeleteSchedule sche = new DeleteSchedule();
			sche.delete();
		}
		if(mode.equalsIgnoreCase("job") || mode.equalsIgnoreCase("all")){
			//ジョブ
			DeleteJob job = new DeleteJob();
			job.delete();
		}
		if(mode.equalsIgnoreCase("notify") || mode.equalsIgnoreCase("all")){
			//通知
			DeleteNotify notify = new DeleteNotify();
			notify.delete();
		}
		if(mode.equalsIgnoreCase("mail") || mode.equalsIgnoreCase("all")){
			//メールテンプレート
			DeleteMailTemplate mail = new DeleteMailTemplate();
			mail.delete();
		}
		if(mode.equalsIgnoreCase("scope") || mode.equalsIgnoreCase("all")){
			//スコープ
			DeleteScope scope = new DeleteScope();
			scope.delete();
		}
		if(mode.equalsIgnoreCase("node") || mode.equalsIgnoreCase("all")){
			//ノード
			DeleteNode node = new DeleteNode();
			node.delete();
		}
		if(mode.equalsIgnoreCase("cal") || mode.equalsIgnoreCase("all")){
			//カレンダ
			DeleteCalendar cal = new DeleteCalendar();
			cal.delete();
		}
		if(mode.equalsIgnoreCase("access") || mode.equalsIgnoreCase("all")){
			//アクセス
			DeleteAccess access = new DeleteAccess();
			access.delete();
		}
//		else{
//		log.error(Messages.getMsg("ImportTool.ModeNotFound"));
//		System.exit(12);
//		}

		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn(Messages.getMsg("ImportTool.DisconnectManagerFailed"), e);
		}

		// 正常終了
		log.info(Messages.getMsg("ImportTool.Exit"));
		System.exit(0);
	}
}
