/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.util;

import javax.ejb.FinderException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.tm.JBossTransactionRolledbackException;
import org.jboss.util.deadlock.ApplicationDeadlockException;

import com.clustercontrol.notify.ejb.session.NotifyController;

/**
 * 通知機能ユーティリティクラス
 * 通知機能に関するユーティリティを格納するクラスです。
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class NotifyUtil {

	// ログ出力
	private static Log log = LogFactory.getLog(NotifyUtil.class);

	/**
	 * 通知IDが存在するかチェックする<BR>
	 * 
	 * @param notifyId 通知ID
	 * @return 結果
	 */
	public static boolean findNotifyId(String notifyId) {
		boolean find = false;

		NotifyController notify = 
			EjbConnectionManager.getConnectionManager().getNotifyController();

		try {
			for(int i = 0; i < 5; i++){
				try {
					notify.getNotify(notifyId);
					find = true;
					break;
				} catch (JBossTransactionRolledbackException e) {
					if(e.getCause() instanceof ApplicationDeadlockException 
							&& i < 4){
						log.debug("ApplicationDeadlockException");
						Thread.sleep(10000);
						continue;
					}
					else{
						throw e;
					}
				}
			}
		} catch (FinderException e) {
		} catch (Exception e) {
			log.error(Messages.getMsg("ImportTool.ConnectManagerFailed"), e);
			System.exit(14);
		}

		return find;
	}
}