/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool;

import java.util.Arrays;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.importtool.conf.job.ImportJob;
import jp.co.intellilink.hinemos.importtool.conf.job.ImportSchedule;
import jp.co.intellilink.hinemos.importtool.util.LoginManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ImportConf メインクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ImportConf {
	// main関数に与えられる引数
	private static String mode = "all";

	// ログ出力
	private static Log log = LogFactory.getLog(ImportConf.class);

	/**
	 * メイン
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		// 実行ログを記載
		log.info(Messages.getMsg("ImportTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		if (args.length > 1) {
			log.error(Messages.getMsg("ImportTool.ArgsInvalid"));
			System.exit(11);
		}

		// 引数の格納
		if(args.length == 0 || args[0].equals(""))
			mode = "all";
		else if(args.length == 1)
			mode = args[0];

		if(mode.equalsIgnoreCase("job") || mode.equalsIgnoreCase("all")){
			//ジョブ
			ImportJob job = new ImportJob();
			job.importJob();
		}
		if(mode.equalsIgnoreCase("sche") || mode.equalsIgnoreCase("all")){
			//ジョブスケジュール
			ImportSchedule sche = new ImportSchedule();
			sche.importSchedule();
		}
//		else{
//		log.error(Messages.getMsg("ImportTool.ModeNotFound"));
//		System.exit(12);
//		}

		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn(Messages.getMsg("ImportTool.DisconnectManagerFailed"), e);
		}

		// 正常終了
		log.info(Messages.getMsg("ImportTool.Exit"));
		System.exit(0);
	}
}
