/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.importtool.master.mib;

import java.util.ArrayList;

import net.percederberg.mibble.MibSymbol;
import net.percederberg.mibble.MibValueSymbol;
import net.percederberg.mibble.snmp.SnmpNotificationType;
import net.percederberg.mibble.value.ObjectIdentifierValue;

import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;

/**
 * Create V2 Trap SnmpTrapMasterData
 * 
 * @version 2.3.0
 * @since 2.3.0
 */
public class TrapV2Factory extends TrapFactory {
	
	private static final String SNMP_TRAPS = ".1.3.6.1.6.3.1.1.5";
	private static final ArrayList<String> GENERIC_TRAPS;
	
	/**
	 * standard traps oid
	 */
	static {
		GENERIC_TRAPS = new ArrayList<String>();
		GENERIC_TRAPS.add("1.3.6.1.6.3.1.1.5.1"); // coldStart
		GENERIC_TRAPS.add("1.3.6.1.6.3.1.1.5.2"); // warmStart
		GENERIC_TRAPS.add("1.3.6.1.6.3.1.1.5.3"); // linkDown
		GENERIC_TRAPS.add("1.3.6.1.6.3.1.1.5.4"); // linkUp
		GENERIC_TRAPS.add("1.3.6.1.6.3.1.1.5.5"); // authenticationFailure
		GENERIC_TRAPS.add("1.3.6.1.6.3.1.1.5.6"); // egpNeighborLoss
	}

	/**
	 * Create SnmpTrapMasterData(snmpv2)
	 * 
	 */
	public SnmpTrapMasterInfo create(MibSymbol symbol) {
		if(symbol == null)
			return null;
		
		SnmpTrapMasterInfo trap = new SnmpTrapMasterInfo();
		
		MibValueSymbol valueSymbol = (MibValueSymbol)symbol;
		SnmpNotificationType notificationType = (SnmpNotificationType)valueSymbol.getType();
		ObjectIdentifierValue value = (ObjectIdentifierValue)valueSymbol.getValue();
		if(!(value.getParent() instanceof ObjectIdentifierValue))
			return null;
		ObjectIdentifierValue parentValue = value.getParent();
		
		// set oid
		String oid = DOT_CHAR + parentValue.getParent().toString()+ DOT_CHAR + parentValue.getValue() + DOT_CHAR + value.getValue();

		int length = oid.length();
		int lastIndex = oid.lastIndexOf(DOT_CHAR);
		
		String lastSubIdStr = oid.substring(lastIndex + 1);
		int lastSubId = -1;
		try {
			lastSubId = Integer.parseInt(lastSubIdStr);
		} catch (NumberFormatException nfe) {
			lastSubId = -1;
		}
		
		// check standard traps
		if (GENERIC_TRAPS.contains(oid)) {
			//TODO GENERIC_TRAPSのOIDだけでは駄目
			// standard traps
			trap.setTrapOid(SNMP_TRAPS + DOT_CHAR + oid.charAt(length - 1));
			trap.setGenericId(lastSubId - 1);
			trap.setSpecificId(0);
		}
		else {
			// not standard traps
			trap.setGenericId(6);
			trap.setSpecificId(lastSubId);
			
			int nextToLastIndex = oid.lastIndexOf(DOT_CHAR, lastIndex - 1);
			String nextToLastSubIdStr = oid.substring(nextToLastIndex + 1, lastIndex);
			if (nextToLastSubIdStr.equals("0")) {
				trap.setTrapOid(oid.substring(0, nextToLastIndex));
			} else {
				trap.setTrapOid(oid.substring(0, lastIndex));
			}
		}

		String uei = value.toDetailString().replaceAll("\\([0-9]*\\)", "");
		uei = uei.replaceAll("\\.", "/");
		uei = uei.replaceAll(".*(mib-2|enterprises)/", "");
		trap.setUei(uei);
		
		// set long message & description
		StringBuilder longmsg = new StringBuilder();
		StringBuilder description = new StringBuilder();
		longmsg.append(value.getName() + "(" + symbol.getMib().getName() + ") received.");
		description.append(notificationType.getDescription());
		for(int i = 0; i < notificationType.getObjects().size(); i++){
			ObjectIdentifierValue tempValue = (ObjectIdentifierValue)notificationType.getObjects().get(i);
			longmsg.append(" " + tempValue.getName() + "=%parm[#" + Integer.toString(i + 1) + "]%");
			description.append("\n" + tempValue.getName() + "=%parm[#" + Integer.toString(i + 1) + "]%");
		}
		
		trap.setLogmsg(longmsg.toString());
		trap.setDescr(description.toString());
		
		return trap;
	}
}