/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.List;

import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;

/**
 * 監視情報を作成するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ImportMonitorNumeric extends ImportMonitor {

	// ログ出力
	private static Log log = LogFactory.getLog(ImportMonitorNumeric.class);

	/**
	 * 監視判定情報を作成する。<br>
	 * 
	 * @param info 監視情報配列
	 * @param monitorInfo 監視情報オブジェクト
	 */
	protected void createMonitorJudgement(List<String> info, MonitorInfo monitorInfo) {
		ArrayList<MonitorNumericValueInfo> list = new ArrayList<MonitorNumericValueInfo>();

		MonitorNumericValueInfo numericValueInfo = new MonitorNumericValueInfo();
		numericValueInfo.setMonitorId(monitorInfo.getMonitorId());
		numericValueInfo.setMonitorTypeId(monitorInfo.getMonitorTypeId());
		numericValueInfo.setPriority(PriorityConstant.TYPE_INFO);
		try {
			numericValueInfo.setThresholdLowerLimit(Double.parseDouble(info.get(0)));
		} catch (NumberFormatException e) {
			String[] args = {monitorInfo.getMonitorId(), PriorityConstant.STRING_INFO};
			log.error(Messages.getMsg("ImportTool.Monitor.1", args));
		}
		try {
			numericValueInfo.setThresholdUpperLimit(Double.parseDouble(info.get(1)));
		} catch (NumberFormatException e) {
			String[] args = {monitorInfo.getMonitorId(), PriorityConstant.STRING_INFO};
			log.error(Messages.getMsg("ImportTool.Monitor.2", args));
		}
		list.add(numericValueInfo);

		numericValueInfo = new MonitorNumericValueInfo();
		numericValueInfo.setMonitorId(monitorInfo.getMonitorId());
		numericValueInfo.setMonitorTypeId(monitorInfo.getMonitorTypeId());
		numericValueInfo.setPriority(PriorityConstant.TYPE_WARNING);
		try {
			numericValueInfo.setThresholdLowerLimit(Double.parseDouble(info.get(2)));
		} catch (NumberFormatException e) {
			String[] args = {monitorInfo.getMonitorId(), PriorityConstant.STRING_WARNING};
			log.error(Messages.getMsg("ImportTool.Monitor.1", args));
		}
		try {
			numericValueInfo.setThresholdUpperLimit(Double.parseDouble(info.get(3)));
		} catch (NumberFormatException e) {
			String[] args = {monitorInfo.getMonitorId(), PriorityConstant.STRING_WARNING};
			log.error(Messages.getMsg("ImportTool.Monitor.2", args));
		}
		list.add(numericValueInfo);
		
		numericValueInfo = new MonitorNumericValueInfo();
		numericValueInfo.setMonitorId(monitorInfo.getMonitorId());
		numericValueInfo.setMonitorTypeId(monitorInfo.getMonitorTypeId());
		numericValueInfo.setPriority(PriorityConstant.TYPE_UNKNOWN);
		numericValueInfo.setThresholdLowerLimit(0);
		numericValueInfo.setThresholdUpperLimit(0);
		list.add(numericValueInfo);
		
		numericValueInfo = new MonitorNumericValueInfo();
		numericValueInfo.setMonitorId(monitorInfo.getMonitorId());
		numericValueInfo.setMonitorTypeId(monitorInfo.getMonitorTypeId());
		numericValueInfo.setPriority(PriorityConstant.TYPE_CRITICAL);
		numericValueInfo.setThresholdLowerLimit(0);
		numericValueInfo.setThresholdUpperLimit(0);
		list.add(numericValueInfo);

		if(info.get(4) instanceof String && info.get(4).length() > 0){
			monitorInfo.setFailurePriority(PriorityConstant.stringToType(info.get(4)));
		}

		monitorInfo.setJudgementInfo(list);
	}
}