#!/bin/bash

# 
# Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# Hinemos Tools
#
# Hinemos Check Tool
#   設定数取得ツール実行スクリプト
# 
# @version 1.0.0
# @since 1.0.0
#

# load Script Configuration
DIR=`dirname $0`
. ${DIR}/lib/hinemos_tools.cfg

# load Hinemos Manager Configuration
. ${HINEMOS_CFG}

JBOSS_DEPLOY=${JBOSS_HOME}/server/default/deploy
JBOSS_LIB=${JBOSS_HOME}/server/default/lib
HINEMOS_LIB=${HINEMOS_HOME}/lib

CLASSPATH=.:${DIR}:${DIR}/lib:${DIR}/lib/hinemos_tools.jar

CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/AccessControlEJB.jar:${JBOSS_DEPLOY}/NotifyEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/PingEJB.jar:${JBOSS_DEPLOY}/HttpEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/HinemosAgentEJB.jar:${JBOSS_DEPLOY}/ProcessEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/PerformanceEJB.jar:${JBOSS_DEPLOY}/PortEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/SnmpEJB.jar:${JBOSS_DEPLOY}/SqlEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/SnmpTrapEJB.jar:${JBOSS_DEPLOY}/SyslogNGEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/MaintenanceEJB.jar:${JBOSS_DEPLOY}/LogTransferEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/RepositoryEJB.jar:${JBOSS_DEPLOY}/JobManagementEJB.jar
CLASSPATH=${CLASSPATH}:${JBOSS_DEPLOY}/CalendarEJB.jar

CLASSPATH=${CLASSPATH}:${JBOSS_LIB}/quartz.jar:${JBOSS_LIB}/org.eclipse.jface_3.1.1.jar

CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/hinemos-commons.jar:${HINEMOS_LIB}/clustercontrol.jar
CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/jbossall-client.jar:${HINEMOS_LIB}/commons-logging-1.1.jar

LOG4J=`find ${HINEMOS_LIB}/log4j*.jar -printf %f`
CLASSPATH=${CLASSPATH}:${HINEMOS_LIB}/${LOG4J}

${JAVA_HOME}/bin/java ${OPT} -Dlogdir=${DIR} -classpath ${CLASSPATH} jp.co.intellilink.hinemos.check.CheckConf $* 2>/dev/null
RET=$?

#echo ${RET}
exit ${RET}
