/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.Iterator;

import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;

/**
 * HTTP監視情報を削除するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class DeleteMonitorHttp {

	// ログ出力
	private static Log log = LogFactory.getLog(DeleteMonitorHttp.class);

	/**
	 * HTTP監視情報を削除する<br>
	 */
	@SuppressWarnings("unchecked")
	public void delete() {
		log.info(Messages.getMsg("Http.Start", new String[]{Messages.getMsg("ImportTool.Delete")}));

		//監視項目リスト取得
		ArrayList idList = getMonitorList();

		if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();

				int monitorType = MonitorTypeConstant.stringToType((String)line.get(3));
				deleteMonitorInfo((String)line.get(0), monitorType);
			}
		}

		log.info(Messages.getMsg("Http.End", new String[]{Messages.getMsg("ImportTool.Delete")}));
	}

	/**
	 * 監視情報を削除する。<br>
	 * 
	 * @param monitorId 監視項目ID
	 * @param monitorType 監視種別
	 */
	protected void deleteMonitorInfo(String monitorId, int monitorType) {
		MonitorHttpController http = EjbConnectionManager.getConnectionManager().getMonitorHttpController();

		try {
			Object[] args = {monitorId};
			log.info(Messages.getMsg("MonitorID", args) + 
					" (" + Messages.getMsg("delete") + ")");

			http.deleteHttp(monitorId, monitorType);
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
	}

	/**
	 * 監視項目リストを取得する。<br>
	 * 
	 * @return 監視項目一覧
	 */
	@SuppressWarnings("unchecked")
	protected ArrayList getMonitorList() {

		MonitorHttpController http = EjbConnectionManager.getConnectionManager().getMonitorHttpController();

		ArrayList records = null;
		try {
			records = http.getHttpList();
		} catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
		return records;
	}
}