/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.conf.repository;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyConstant;
import com.clustercontrol.bean.SnmpVersionConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.repository.factory.NodeProperty;
import com.clustercontrol.util.PropertyUtil;

/**
 * ノード情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportNode {
	
	// ログ出力
	private static Log log = LogFactory.getLog(ExportNode.class);

    /**
     * ノード情報をExportする。<br>
     */
    public void exportNode() {
    	log.info(Messages.getMsg("Node.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
    	
    	//CSV出力配列を用意
    	ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
    	
    	//ファシリティIDリスト取得
    	ArrayList idList = getNodeList();
    	
    	if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				String id = (String)itr.next();
				
				Object[] args = {id};
				log.info(Messages.getMsg("FacilityID", args));
				
				Property info = getNode(id);
				csvOutput.add(createCsvFormat(info));
			}
			
			//ファシリティIDでソート
			Collections.sort(csvOutput, new StringListComparator(0));
    	}
    	
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Export.Dir") + "/NODE_" + format.format(new Date()) + ".csv", 
				csvOutput);
		
		log.info(Messages.getMsg("Node.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }
    
    /**
	 * ノード情報をExportする。<br>
	 * 
	 * @param info ノード情報
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<String> createCsvFormat(Property info) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		ArrayList values = null;
		
		//ファシリティID
		values = PropertyUtil.getPropertyValue(info, NodeProperty.FACILITY_ID);
		csvFormat.add(getStringValue(values));
		//ファシリティ名
		values = PropertyUtil.getPropertyValue(info, NodeProperty.FACILITY_NAME);
		csvFormat.add(getStringValue(values));
		//説明
		values = PropertyUtil.getPropertyValue(info, NodeProperty.DESCRIPTION);
		csvFormat.add(getStringValue(values));
		//プラットフォーム
		values = PropertyUtil.getPropertyValue(info, NodeProperty.PLATFORM_FAMILY_NAME);
		csvFormat.add(getStringValue(values));
		//H/Wタイプ
		values = PropertyUtil.getPropertyValue(info, NodeProperty.HARDWARE_TYPE);
		csvFormat.add(getStringValue(values));
		//画面アイコンイメージ
		values = PropertyUtil.getPropertyValue(info, NodeProperty.ICONIMAGE);
		csvFormat.add(getStringValue(values));
		//管理対象
		values = PropertyUtil.getPropertyValue(info, NodeProperty.VALID);
		csvFormat.add(getBooleanValue(values));
		
		//SNMPポート番号
		values = PropertyUtil.getPropertyValue(info, NodeProperty.SNMP_PORT);
		csvFormat.add(getIntegerValue(values));
		//SNMPコミュニティ名
		values = PropertyUtil.getPropertyValue(info, NodeProperty.SNMP_COMMUNITY);
		csvFormat.add(getStringValue(values));
		//SNMPバージョン
		values = PropertyUtil.getPropertyValue(info, NodeProperty.SNMP_VERSION);
//Hinemos3.0.0のバグ対応 --->
		String snmpVersion = getStringValue(values);
		if(!snmpVersion.equals(SnmpVersionConstant.STRING_V1) && !snmpVersion.equals(SnmpVersionConstant.STRING_V2))
			snmpVersion = "";
		csvFormat.add(snmpVersion);
//		csvFormat.add(getStringValue(values));
//Hinemos3.0.0のバグ対応 <---
		//SNMPタイムアウト
		values = PropertyUtil.getPropertyValue(info, NodeProperty.SNMPTIMEOUT);
		csvFormat.add(getIntegerValue(values));
		//SNMPリトライ回数
		values = PropertyUtil.getPropertyValue(info, NodeProperty.SNMPRETRIES);
		csvFormat.add(getIntegerValue(values));
		//SNMPプロキシ
		values = PropertyUtil.getPropertyValue(info, NodeProperty.SNMPPROXY);
		csvFormat.add(getStringValue(values));
		
		//DHCPクライアント
		values = PropertyUtil.getPropertyValue(info, NodeProperty.DHCP_CLIENT);
		csvFormat.add(getBooleanValue(values));
		//IPアドレス種別
		values = PropertyUtil.getPropertyValue(info, NodeProperty.IP_ADDRESS_TYPE);
		csvFormat.add(getIntegerValue(values));
		//IPアドレスバージョン
		values = PropertyUtil.getPropertyValue(info, NodeProperty.IP_ADDRESS_VERSION);
		csvFormat.add(getIntegerValue(values));
		//IPアドレスV4
		values = PropertyUtil.getPropertyValue(info, NodeProperty.IP_ADDRESS_V4);
		csvFormat.add(getStringValue(values));
		//IPアドレスV6
		values = PropertyUtil.getPropertyValue(info, NodeProperty.IP_ADDRESS_V6);
		csvFormat.add(getStringValue(values));
		//ホスト名
		values = PropertyUtil.getPropertyValue(info, NodeProperty.HOST_NAME);
		csvFormat.add(getStringValue(values));
		
		//ノード名
		values = PropertyUtil.getPropertyValue(info, NodeProperty.NODE_NAME);
		csvFormat.add(getStringValue(values));
		//OS名
		values = PropertyUtil.getPropertyValue(info, NodeProperty.OS_NAME);
		csvFormat.add(getStringValue(values));
		//OSリリース
		values = PropertyUtil.getPropertyValue(info, NodeProperty.OS_RELEASE);
		csvFormat.add(getStringValue(values));
		//OSバージョン
		values = PropertyUtil.getPropertyValue(info, NodeProperty.OS_VERSION);
		csvFormat.add(CheckString.checkReturn(getStringValue(values)));
		//文字セット
		values = PropertyUtil.getPropertyValue(info, NodeProperty.CHARACTER_SET);
		csvFormat.add(getStringValue(values));
		
		//仮想化ノード種別
		values = PropertyUtil.getPropertyValue(info, NodeProperty.VIRTNODETYPE);
		csvFormat.add(getStringValue(values));
		//仮想化管理ノード
		values = PropertyUtil.getPropertyValue(info, NodeProperty.VMMANAGEMENTNODE);
		csvFormat.add(getStringValue(values));
		//仮想マシンINDEX
		values = PropertyUtil.getPropertyValue(info, NodeProperty.VMINDEX);
		csvFormat.add(getIntegerValue(values));
		//仮想マシン名
		values = PropertyUtil.getPropertyValue(info, NodeProperty.VMNAME);
		csvFormat.add(getStringValue(values));
		//仮想化ソリューション
		values = PropertyUtil.getPropertyValue(info, NodeProperty.VIRTSOLUTION);
		csvFormat.add(getStringValue(values));
		
		return csvFormat;
	}
	
	/**
	 * 配列から文字列を取得する。<br>
	 * 
	 * @param values 配列
	 * @return 文字列
	 */
	public String getStringValue(ArrayList values) {
		if(values.size() > 0 && values.get(0) instanceof String)
			return (String)values.get(0);
		else
			return "";
	}
	
	/**
	 * 配列から数値を取得し文字列に変換する。<br>
	 * 
	 * @param values 配列
	 * @return 文字列
	 */
	public String getIntegerValue(ArrayList values) {
		if(values.size() > 0 && values.get(0) instanceof Integer)
			return ((Integer)values.get(0)).toString();
		else
			return "";
	}
	
	/**
	 * 配列からBooleanを取得し文字列に変換する。<br>
	 * 
	 * @param values 配列
	 * @return 文字列
	 */
	public String getBooleanValue(ArrayList values) {
		if(values.size() > 0 && values.get(0) instanceof Boolean)
			if(((Boolean)values.get(0)).booleanValue())
				return YesNoConstant.typeToString(YesNoConstant.TYPE_YES);
			else
				return YesNoConstant.typeToString(YesNoConstant.TYPE_NO);
		else
			return "";
	}
	
    /**
     * ノード情報を取得する。<br>
     * 
     * @param facilityId 取得対象のファシリティID
     * @return ノード情報
     */
    protected Property getNode(String facilityId) {

    	RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

    	Property info = null;
        try {
        	info = repository.getNodeProperty(facilityId, PropertyConstant.MODE_SHOW, Locale.getDefault());
        } catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
        }
        return info;
    }
    
    /**
     * ファシリティIDリストを取得する。<br>
     * 
     * @return ファシリティID一覧
     */
    protected ArrayList getNodeList() {

    	RepositoryController repository = EjbConnectionManager.getConnectionManager().getRepositoryController();

        ArrayList records = null;
        try {
            records = repository.getNodeFacilityIdList();
        } catch (Exception e) {
			log.error(Messages.getMsg("ConnectManagerFailed"), e);
			System.exit(14);
		}
        return records;
    }
}