/*

Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.importtool.conf.monitor;

import java.util.ArrayList;
import java.util.List;

import jp.co.intellilink.hinemos.util.CheckString;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.NotifyUtil;
import jp.co.intellilink.hinemos.util.SelectArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.NotifyTypeConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;

/**
 * 監視情報を作成するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ImportMonitorString extends ImportMonitor {

	// ログ出力
	private static Log log = LogFactory.getLog(ImportMonitorString.class);

	protected ArrayList<ArrayList<String>> monitorRuleInfos = null;

	/**
	 * 監視判定情報を作成する。<br>
	 * 
	 * @param monitorInfo 監視情報オブジェクト
	 */
	protected void createMonitorJudgement(MonitorInfo monitorInfo) {
		ArrayList<MonitorStringValueInfo> list = new ArrayList<MonitorStringValueInfo>();

		ArrayList<ArrayList<String>> ruleInfos = 
			SelectArrayList.select(monitorRuleInfos, 0, monitorInfo.getMonitorId());
		for(ArrayList<String> ruleInfo : ruleInfos){
			MonitorStringValueInfo stringValueInfo = new MonitorStringValueInfo();
			//監視項目ID
			stringValueInfo.setMonitorId(monitorInfo.getMonitorId());

			//監視種別ID
			stringValueInfo.setMonitorTypeId(monitorInfo.getMonitorTypeId());

			//順序
			stringValueInfo.setOrderNo(Integer.parseInt(ruleInfo.get(1)));

			//説明
			String description = CheckString.checkLength(ruleInfo.get(2), DataRangeConstant.VARCHAR_256);
			if(!description.equals(ruleInfo.get(2))){
				String[] args = { com.clustercontrol.util.Messages.getString("description"), "256" };
				log.warn(Messages.getMsg("ImportTool.Common.2", args));
			}
			stringValueInfo.setDescription(description);

			//パターンマッチ表現
			String pattern = CheckString.checkLength(ruleInfo.get(3), DataRangeConstant.VARCHAR_1024);
			if(!pattern.equals(ruleInfo.get(3))){
				String[] args = { com.clustercontrol.util.Messages.getString("pattern.matching.expression"), "1024" };
				log.warn(Messages.getMsg("ImportTool.Common.2", args));
			}
			stringValueInfo.setPattern(pattern);

			//処理有無
			stringValueInfo.setProcessType(ProcessConstant.stringToType(ruleInfo.get(4)));

			//監視通知情報
			createMonitorJudgementNotify(ruleInfo.subList(5, 10), stringValueInfo, monitorInfo);

			//重要度
			stringValueInfo.setPriority(PriorityConstant.stringToType(ruleInfo.get(10)));

			//メッセージID
			String id = CheckString.checkLength(ruleInfo.get(11), DataRangeConstant.VARCHAR_64);
			if(!id.equals(ruleInfo.get(11))){
				String[] args = { com.clustercontrol.util.Messages.getString("message.id"), "64" };
				log.warn(Messages.getMsg("ImportTool.Common.2", args));
			}
			stringValueInfo.setMessageId(id);

			//メッセージ
			String message = CheckString.checkLength(ruleInfo.get(12), DataRangeConstant.VARCHAR_256);
			if(!message.equals(ruleInfo.get(12))){
				String[] args = { com.clustercontrol.util.Messages.getString("message"), "256" };
				log.warn(Messages.getMsg("ImportTool.Common.2", args));
			}
			stringValueInfo.setMessage(message);

			//有効/無効
			stringValueInfo.setValidFlg(
					YesNoConstant.typeToBoolean(
							YesNoConstant.stringToType(ruleInfo.get(13))));

			list.add(stringValueInfo);
		}

		monitorInfo.setJudgementInfo(list);
	}

	/**
	 * 監視通知情報を設定する。<br>
	 * 
	 * @param info 監視判定情報配列
	 * @param stringValueInfo 監視判定情報オブジェクト
	 * @param monitorInfo 監視情報オブジェクト
	 */
	protected void createMonitorJudgementNotify(List<String> info, MonitorStringValueInfo stringValueInfo, MonitorInfo monitorInfo) {
		stringValueInfo.setNotifyGroupId(NotifyRelationInfo.createNotifyGroupId(instanceToTypeId(monitorInfo), stringValueInfo.getMonitorId(), stringValueInfo.getOrderNo()));

		ArrayList<NotifyRelationInfo> notifyList = new ArrayList<NotifyRelationInfo>();

		for(int i = 0; i < 5; i++){
			if(info.get(i) instanceof String && info.get(i).length() > 0){
				if(!NotifyUtil.findNotifyId(info.get(i))){
					String args[] = {stringValueInfo.getMonitorId(), info.get(i)};
					log.error(Messages.getMsg("ImportTool.Notify.1", args));
					System.exit(20);
				}

				NotifyRelationInfo relationInfo = new NotifyRelationInfo();
				relationInfo.setNotifyId(info.get(i));
				relationInfo.setNotifyGroupId(stringValueInfo.getNotifyGroupId());
				relationInfo.setNotifyFlg(0);

				if(i == 0)
					relationInfo.setNotifyType(NotifyTypeConstant.TYPE_STATUS);
				else if(i == 1)
					relationInfo.setNotifyType(NotifyTypeConstant.TYPE_EVENT);
				else if(i == 2)
					relationInfo.setNotifyType(NotifyTypeConstant.TYPE_MAIL);
				else if(i == 3)
					relationInfo.setNotifyType(NotifyTypeConstant.TYPE_JOB);
				else if(i == 4)
					relationInfo.setNotifyType(NotifyTypeConstant.TYPE_LOG_ESCALATE);

				notifyList.add(relationInfo);
			}
		}
		stringValueInfo.setNotifyId(notifyList);
	}
}