/*

Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.

 */

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import com.clustercontrol.bean.NotifyTypeConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.notify.bean.NotifyRelationInfo;

/**
 * 監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMonitorString extends ExportMonitor {

	/**
	 * 監視情報をExportする。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return CSVフォーマット文字列
	 * 
	 * @see jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitor#createCsvFormat(com.clustercontrol.monitor.run.bean.MonitorInfo)
	 */
	@Override
	public ArrayList<String> createCsvFormat(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();

		//監視基本情報
		csvFormat.addAll(createMonitorBase(monitorInfo));

		//監視条件情報
		csvFormat.addAll(createMonitorRule(monitorInfo));

		//監視情報
		csvFormat.addAll(createMonitorInfo(monitorInfo));

		//監視通知情報
		csvFormat.addAll(createMonitorNotify(monitorInfo));

		//アプリケーション
		if (monitorInfo.getApplication() != null)
			csvFormat.add(monitorInfo.getApplication());
		else
			csvFormat.add("");

		//値取得失敗時
		csvFormat.add(PriorityConstant.typeToString(monitorInfo.getFailurePriority()));

		//有効/無効
		csvFormat.add(ValidConstant.typeToString(monitorInfo.getValid()));

		return csvFormat;
	}

	/**
	 * 監視判定情報をExportする。<br>
	 * 
	 * @param monitorInfo 監視情報
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<ArrayList<String>> createMonitorJudgement(MonitorInfo monitorInfo) {
		ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();

		ArrayList list = monitorInfo.getJudgementInfo();
		if(list instanceof ArrayList){
			Iterator itr = list.iterator();
			while(itr.hasNext()){
				MonitorStringValueInfo line = (MonitorStringValueInfo)itr.next();

				ArrayList<String> csvFormat = new ArrayList<String>();

				//監視項目ID
				csvFormat.add(monitorInfo.getMonitorId());

				//順序
				csvFormat.add(String.valueOf(line.getOrderNo()));

				//説明
				if (line.getDescription() != null)
					csvFormat.add(line.getDescription());
				else
					csvFormat.add("");

				//パターンマッチ表現
				if (line.getPattern() != null)
					csvFormat.add(line.getPattern());
				else
					csvFormat.add("");

				//処理有無
				csvFormat.add(ProcessConstant.typeToString(line.getProcessType()));

				//通知情報
				csvFormat.addAll(createMonitorJudgementNotify(line));

				//重要度
				csvFormat.add(PriorityConstant.typeToString(line.getPriority()));

				//メッセージID
				if (line.getMessageId() != null)
					csvFormat.add(line.getMessageId());
				else
					csvFormat.add("");

				//メッセージ
				if (line.getMessage() != null)
					csvFormat.add(line.getMessage());
				else
					csvFormat.add("");

				//有効/無効
				if(line.isValidFlg())
					csvFormat.add(YesNoConstant.typeToString(YesNoConstant.TYPE_YES));
				else
					csvFormat.add(YesNoConstant.typeToString(YesNoConstant.TYPE_NO));

				csvOutput.add(csvFormat);
			}
		}

		return csvOutput;
	}

	/**
	 * 監視判定情報の通知情報をExportする。<br>
	 * 
	 * @param monitorInfo 監視判定情報
	 * @return CSVフォーマット文字列
	 */
	protected ArrayList<String> createMonitorJudgementNotify(MonitorStringValueInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();

		String status = "";
		String event = "";
		String mail = "";
		String job = "";
		String syslog = "";

		if(monitorInfo.getNotifyId() != null){
			Collection<NotifyRelationInfo> notify = monitorInfo.getNotifyId();

			NotifyRelationInfo relationInfo;
			for (int i = 0; i < notify.size(); i++) {
				relationInfo = (NotifyRelationInfo)((ArrayList<NotifyRelationInfo>)notify).get(i);
				if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_STATUS)
					status = relationInfo.getNotifyId();
				else if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_EVENT)
					event = relationInfo.getNotifyId();
				else if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_MAIL)
					mail = relationInfo.getNotifyId();
				else if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_JOB)
					job = relationInfo.getNotifyId();
				else if(relationInfo.getNotifyType() == NotifyTypeConstant.TYPE_LOG_ESCALATE)
					syslog = relationInfo.getNotifyId();
			}
		}

		csvFormat.add(status);
		csvFormat.add(event);
		csvFormat.add(mail);
		csvFormat.add(job);
		csvFormat.add(syslog);

		return csvFormat;
	}
}