/*
 
Copyright (C) 2009 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

import javax.naming.NamingException;

import jp.co.intellilink.hinemos.export.history.ExportCollectiveRun;
import jp.co.intellilink.hinemos.export.history.ExportEvent;
import jp.co.intellilink.hinemos.export.history.ExportJob;
import jp.co.intellilink.hinemos.export.history.ExportPerformance;
import jp.co.intellilink.hinemos.export.history.ExportStatus;
import jp.co.intellilink.hinemos.export.util.LoginManager;
import jp.co.intellilink.hinemos.export.util.Messages;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ExportHistory メインクラス<br>
 * 
 * @version 1.1.0
 * @since 1.1.0
 */
public class ExportHistory {
	// main関数に与えられる引数
	private static String mode = "all";
	// イベント情報チェック開始日時
	private static Date startDate = null;

	// ログ出力
	private static Log log = LogFactory.getLog(ExportHistory.class);

	/**
	 * メイン
	 * 
	 * @param args
	 */
	public static void main(String[] args) {

		// 実行ログを記載
		log.info(Messages.getMsg("ExportTool.Exec") + " : " + Arrays.toString(args));

		// 引数の数の確認
		if (args.length > 2) {
			log.error(Messages.getMsg("ExportTool.ArgsInvalid"));
			System.exit(11);
		}

		// 引数の格納
		if(args.length == 0 || args[0].equals(""))
			mode = "all";
		else if(args.length >= 1)
			mode = args[0];
		
		// 引数の格納
		if(args.length >= 2){
			try {
				startDate = DateFormat.getDateTimeInstance().parse(args[1]);
			} catch (ParseException e) {
				try {
					startDate = DateFormat.getDateInstance().parse(args[1]);
				} catch (ParseException e1) {
					try {
						Calendar cal = Calendar.getInstance();
						cal.add(Calendar.DATE, Integer.parseInt(args[1]));
						startDate = cal.getTime();
					} catch (NumberFormatException e2) {
					}
				}
			}
		}
		if(startDate == null){
			startDate = new Date();
		}

		if(mode.equalsIgnoreCase("event") || mode.equalsIgnoreCase("all")){
			//イベント出力
			ExportEvent event = new ExportEvent();
			event.export(startDate);
		}
		if(mode.equalsIgnoreCase("status") || mode.equalsIgnoreCase("all")){
			//ステータス出力
			ExportStatus status = new ExportStatus();
			status.export();
		}
		if(mode.equalsIgnoreCase("perf") || mode.equalsIgnoreCase("all")){
			//性能管理機能の実績収集
			ExportPerformance performance = new ExportPerformance();
			performance.export(startDate);
		}
		if(mode.equalsIgnoreCase("job") || mode.equalsIgnoreCase("all")){
			//ジョブ実行履歴
			ExportJob job = new ExportJob();
			job.export(startDate);
		}
		if(mode.equalsIgnoreCase("crun") || mode.equalsIgnoreCase("all")){
			//一括制御の実行履歴
			ExportCollectiveRun collectiveRun = new ExportCollectiveRun();
			collectiveRun.export(startDate);
		}
//		else{
//		log.error(Messages.getMsg("ExportTool.ModeNotFound"));
//		System.exit(12);
//		}

		// マネージャー接続の切断
		try {
			LoginManager.getContextManager().logout();
		} catch (NamingException e) {
			log.warn(Messages.getMsg("ExportTool.DisconnectManagerFailed"), e);
		}

		// 正常終了
		log.info(Messages.getMsg("ExportTool.Exit"));
		System.exit(0);
	}
}
