/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.conf.notify;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

import jp.co.intellilink.hinemos.export.util.CheckString;
import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.notify.mail.ejb.entity.MailTemplateInfoData;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;

/**
 * メールテンプレート情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMailTemplate {
	
	// ログ出力
	private static Log log = LogFactory.getLog(ExportMailTemplate.class);

    /**
     * メールテンプレート情報をExportする。<br>
     */
    public void exportMailTemplate() {
    	log.info(Messages.getMsg("ExportTool.MailTemplate.Start"));
    	
    	//CSV出力配列を用意
    	ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
    	
    	//メールテンプレートIDリスト取得
    	ArrayList idList = getMailTemplateIdList();
    	
    	if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				String id = (String)itr.next();
				
				Object[] args = {id};
				log.info(Messages.getMsg("ExportTool.MailTemplateID", args));
				
				MailTemplateInfoData info = getMailTemplate(id);
				csvOutput.add(createCsvFormat(info));
			}
			
			//メールテンプレートIDでソート
			Collections.sort(csvOutput, new StringListComparator(0));
    	}
		
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
		
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Output.Dir.Conf") + "/MAILTEMPLATE_" + format.format(new Date()) + ".csv", 
				csvOutput);
		
		log.info(Messages.getMsg("ExportTool.MailTemplate.End"));
    }
    
    /**
	 * メールテンプレート情報をExportする。<br>
	 * 
	 * @param mailTemplateInfo メールテンプレート情報
	 * @return CSVフォーマット文字列
	 */
	public ArrayList<String> createCsvFormat(MailTemplateInfoData mailTemplateInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		//メールテンプレートID
		csvFormat.add(mailTemplateInfo.getMailTemplateId());
		//説明
		if(mailTemplateInfo.getDescription() != null)
			csvFormat.add(mailTemplateInfo.getDescription());
		else
			csvFormat.add("");
		//件名
		if(mailTemplateInfo.getSubject() != null)
			csvFormat.add(mailTemplateInfo.getSubject());
		else
			csvFormat.add("");
		//本文
		if(mailTemplateInfo.getBody() != null)
			csvFormat.add(CheckString.checkReturn(mailTemplateInfo.getBody()));
		else
			csvFormat.add("");
		
		return csvFormat;
	}

	/**
     * メールテンプレート情報を取得する。<br>
     * 
     * @param mailTemplateId 取得対象の通知ID
     * @return メールテンプレート情報
     */
    protected MailTemplateInfoData getMailTemplate(String mailTemplateId) {

        MailTemplateController mail = EjbConnectionManager.getConnectionManager().getMailTemplateController();

        MailTemplateInfoData info = null;
        try {
        	info = mail.getMailTemplateInfo(mailTemplateId);
        } catch (Exception e) {
			log.error(Messages.getMsg("ExportTool.ConnectManagerFailed"), e);
			System.exit(14);
        }
        return info;
    }
    
    /**
     * メールテンプレートIDリストを取得する。<br>
     * 
     * @return メールテンプレートID一覧
     */
    protected ArrayList getMailTemplateIdList() {

        MailTemplateController mail = EjbConnectionManager.getConnectionManager().getMailTemplateController();

        ArrayList records = null;
        try {
            records = mail.getMailTemplateIdList();
        } catch (Exception e) {
			log.error(Messages.getMsg("ExportTool.ConnectManagerFailed"), e);
			System.exit(14);
        }
        return records;
    }
}