/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.util.ArrayList;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;

/**
 * 監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMonitorNumeric extends ExportMonitor {
	/** 入力値の検証タイプ（整数）。 */
	public static final int INPUT_VERIFICATION_INTEGER_NUMBER = 0;
	/** 入力値の検証タイプ（実数）。 */
	public static final int INPUT_VERIFICATION_REAL_NUMBER = 1;
	/** 入力値の検証タイプ（正の整数）。 */
	public static final int INPUT_VERIFICATION_POSITIVE_INTEGER = 2;
	/** 入力値の検証タイプ（正の実数）。 */
	public static final int INPUT_VERIFICATION_POSITIVE_REAL = 3;
	
	/** 入力値の検証タイプ（判定項目１）。 */
	private int m_inputVerifyType1 = INPUT_VERIFICATION_INTEGER_NUMBER;
	
	/** 入力値の検証タイプ（判定項目２）。 */
	private int m_inputVerifyType2 = INPUT_VERIFICATION_INTEGER_NUMBER;
	
	public ExportMonitorNumeric(int inputVerifyType){
		m_inputVerifyType1 = inputVerifyType;
		m_inputVerifyType2 = inputVerifyType;
	}
	
	public ExportMonitorNumeric(int inputVerifyType1, int inputVerifyType2){
		m_inputVerifyType1 = inputVerifyType1;
		m_inputVerifyType2 = inputVerifyType2;
	}
	
    /**
	 * 監視情報をExportする。<br>
	 * 
	 * @param monitorInfo Ping監視情報
	 * @return CSVフォーマット文字列
	 * 
	 * @see jp.co.intellilink.hinemos.export.conf.monitor.ExportMonitor#createCsvFormat(com.clustercontrol.monitor.run.bean.MonitorInfo)
	 */
	@Override
	public ArrayList<String> createCsvFormat(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		//監視基本情報
		csvFormat.addAll(createMonitorBase(monitorInfo));
		
		//監視条件情報
		csvFormat.addAll(createMonitorRule(monitorInfo));
		
		//監視情報
		csvFormat.addAll(createMonitorInfo(monitorInfo));

		//監視単位情報
		csvFormat.addAll(createMonitorBlock(monitorInfo));
		
		//監視判定情報
		csvFormat.addAll(createMonitorJudgement(monitorInfo));
		
		//監視通知情報
		csvFormat.addAll(createMonitorNotify(monitorInfo));

        //アプリケーション
        if (monitorInfo.getApplication() != null)
        	csvFormat.add(monitorInfo.getApplication());
        else
        	csvFormat.add("");
        
        //有効/無効
        csvFormat.add(ValidConstant.typeToString(monitorInfo.getValid()));
		
		return csvFormat;
	}
	
	/**
     * 監視判定情報をExportする。<br>
     * 
     * @param monitorInfo 監視情報
     * @return CSVフォーマット文字列
     */
	protected ArrayList<String> createMonitorJudgement(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		ArrayList<String> info = new ArrayList<String>();
		ArrayList<String> warning = new ArrayList<String>();
		
		for(int i=0; i < 2; i++){
			info.add("");
			warning.add("");
		}
		
		ArrayList list = monitorInfo.getJudgementInfo();
		if(list != null){
			for(int i=0; i < list.size(); i++){
				MonitorNumericValueInfo numericValueInfo = (MonitorNumericValueInfo)list.get(i);
				if(numericValueInfo != null){
					ArrayList<String> priority = null;
					if(PriorityConstant.TYPE_INFO ==  numericValueInfo.getPriority()){
						priority = info;
					}
					else if(PriorityConstant.TYPE_WARNING ==  numericValueInfo.getPriority()){
						priority = warning;
					}
					else{
						continue;
					}
					
					if(m_inputVerifyType1  == INPUT_VERIFICATION_INTEGER_NUMBER || 
							m_inputVerifyType1  == INPUT_VERIFICATION_POSITIVE_INTEGER){
						priority.set(0, Long.toString(Double.valueOf(numericValueInfo.getThresholdLowerLimit()).longValue()));
					}
					else{
						priority.set(0, Double.toString(numericValueInfo.getThresholdLowerLimit()));
					}
					if(m_inputVerifyType2  == INPUT_VERIFICATION_INTEGER_NUMBER || 
							m_inputVerifyType2  == INPUT_VERIFICATION_POSITIVE_INTEGER){
						priority.set(1, Long.toString(Double.valueOf(numericValueInfo.getThresholdUpperLimit()).longValue()));
					}
					else{
						priority.set(1, Double.toString(numericValueInfo.getThresholdUpperLimit()));
					}
				}
			}
		}

		csvFormat.addAll(info);
		csvFormat.addAll(warning);
		csvFormat.add(PriorityConstant.typeToString(monitorInfo.getFailurePriority()));
		
		return csvFormat;
	}
}