/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.conf.monitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

import jp.co.intellilink.hinemos.export.util.Config;
import jp.co.intellilink.hinemos.export.util.StringListComparator;
import jp.co.intellilink.hinemos.export.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.export.util.Messages;
import jp.co.intellilink.hinemos.export.util.WriteCsvFile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.bean.MonitorPingInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingController;

/**
 * Ping監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMonitorPing extends ExportMonitorNumeric {

	// ログ出力
	private static Log log = LogFactory.getLog(ExportMonitorPing.class);
	
    public ExportMonitorPing() {
		super(ExportMonitorNumeric.INPUT_VERIFICATION_POSITIVE_REAL, 
				ExportMonitorNumeric.INPUT_VERIFICATION_POSITIVE_INTEGER);
	}

	/**
     * Ping監視情報をExportする。<br>
     */
    public void exportPing() {
    	log.info(Messages.getMsg("ExportTool.Ping.Start"));
    	
    	//CSV出力配列を用意
    	ArrayList<ArrayList<String>> csvOutput = new ArrayList<ArrayList<String>>();
    	
    	//監視項目リスト取得
    	ArrayList idList = getPingList();
    	
    	if(idList instanceof ArrayList){
			Iterator itr = idList.iterator();
			while(itr.hasNext()){
				ArrayList line = (ArrayList)itr.next();
				
				Object[] args = {(String)line.get(0)};
				log.info(Messages.getMsg("ExportTool.MonitorID", args));
				
				MonitorInfo info = getPing((String)line.get(0));
				csvOutput.add(createCsvFormat(info));
			}
			
			//監視項目IDでソート
			Collections.sort(csvOutput, new StringListComparator(0));
    	}
    	
		SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd_HHmmss");
		
		WriteCsvFile.writeCsvFile(
				Config.getConfig("Output.Dir.Conf") + "/PING_" + format.format(new Date()) + ".csv", 
				csvOutput);
		
		log.info(Messages.getMsg("ExportTool.Ping.End"));
    }
    
    /**
	 * Ping監視情報をExportする。<br>
	 * 
	 * @param monitorInfo Ping監視情報
	 * @return CSVフォーマット文字列
	 */
    @Override
	public ArrayList<String> createMonitorInfo(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
        MonitorPingInfo pingInfo = (MonitorPingInfo)monitorInfo.getCheckInfo();
        if(pingInfo == null){
        	pingInfo = new MonitorPingInfo();
        }
        //回数
        if (pingInfo.getRunCount() != null)
        	csvFormat.add(PingRunCountConstant.typeToString(pingInfo.getRunCount().intValue()));
        else
        	csvFormat.add("");
        //間隔
        if (pingInfo.getRunInterval() != null)
        	csvFormat.add(PingRunIntervalConstant.typeToString(pingInfo.getRunInterval().intValue()));
        else
        	csvFormat.add("");
        //タイムアウト
        if (pingInfo.getTimeout() != null)
        	csvFormat.add(pingInfo.getTimeout().toString());
        else
        	csvFormat.add("");

		return csvFormat;
	}

    /**
     * Ping監視情報を取得する。<br>
     * 
     * @param monitorId 取得対象の監視項目ID
     * @return Ping監視情報
     */
    protected MonitorInfo getPing(String monitorId) {

        MonitorPingController ping = EjbConnectionManager.getConnectionManager().getMonitorPingController();

        MonitorInfo info = null;
        try {
        	info = ping.getPing(monitorId);
        } catch (Exception e) {
			log.error(Messages.getMsg("ExportTool.ConnectManagerFailed"), e);
			System.exit(14);
        }
        return info;
    }
    
    /**
     * 監視項目リストを取得する。<br>
     * 
     * @return 監視項目一覧
     */
    protected ArrayList getPingList() {

    	MonitorPingController ping = EjbConnectionManager.getConnectionManager().getMonitorPingController();

    	ArrayList records = null;
    	try {
    		records = ping.getPingList();
        } catch (Exception e) {
			log.error(Messages.getMsg("ExportTool.ConnectManagerFailed"), e);
			System.exit(14);
        }
        return records;
    }
}