/*
 
Copyright (C) 2008 NTT DATA INTELLILINK CORPORATION
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package jp.co.intellilink.hinemos.export.monitor;

import java.util.ArrayList;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.monitor.run.bean.TruthConstant;

/**
 * 監視情報を取得するクラス<br>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ExportMonitorTruth extends ExportMonitor {

    /**
	 * 監視情報をExportする。<br>
	 * 
	 * @param monitorInfo Ping監視情報
	 * @return CSVフォーマット文字列
	 * 
	 * @see jp.co.intellilink.hinemos.export.monitor.ExportMonitor#createCsvFormat(com.clustercontrol.monitor.run.bean.MonitorInfo)
	 */
	@Override
	public ArrayList<String> createCsvFormat(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		//監視基本情報
		csvFormat.addAll(createMonitorBase(monitorInfo));
		
		//監視条件情報
		csvFormat.addAll(createMonitorRule(monitorInfo));
		
		//監視情報
		csvFormat.addAll(createMonitorInfo(monitorInfo));

		//監視単位情報
		csvFormat.addAll(createMonitorBlock(monitorInfo));
		
		//監視判定情報
		csvFormat.addAll(createMonitorJudgement(monitorInfo));
		
		//監視通知情報
		csvFormat.addAll(createMonitorNotify(monitorInfo));

        //アプリケーション
        if (monitorInfo.getApplication() != null)
        	csvFormat.add(monitorInfo.getApplication());
        else
        	csvFormat.add("");
        
        //有効/無効
        csvFormat.add(ValidConstant.typeToString(monitorInfo.getValid()));
		
		return csvFormat;
	}
	
	/**
     * 監視判定情報をExportする。<br>
     * 
     * @param monitorInfo 監視情報
     * @return CSVフォーマット文字列
     */
	protected ArrayList<String> createMonitorJudgement(MonitorInfo monitorInfo) {
		ArrayList<String> csvFormat = new ArrayList<String>();
		
		String ok = "";
		String ng = "";
		
		ArrayList list = monitorInfo.getJudgementInfo();
		if(list != null){
			for(int i=0; i < list.size(); i++){
            	MonitorTruthValueInfo truthValueInfo = (MonitorTruthValueInfo)list.get(i);
            	if(truthValueInfo != null){
                	if(truthValueInfo.getTruthValue() == TruthConstant.TYPE_TRUE){
                		ok = PriorityConstant.typeToString(truthValueInfo.getPriority());
                	}
                	else if(truthValueInfo.getTruthValue() == TruthConstant.TYPE_FALSE){
                		ng = PriorityConstant.typeToString(truthValueInfo.getPriority());
                	}
            	}
			}
		}

		csvFormat.add(ok);
		csvFormat.add(ng);
		csvFormat.add(PriorityConstant.typeToString(monitorInfo.getFailurePriority()));
		
		return csvFormat;
	}
}