/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common;

import jp.co.dgic.eclipse.jdt.internal.junit.runner.MessageSender;
import jp.co.dgic.eclipse.jdt.internal.junit.ui.DJUnitMessages;
import jp.co.dgic.testing.common.DJUnitClassLoader;

public class DJUnitEclipseClassLoader
extends DJUnitClassLoader {
    protected MessageSender messageSender;

    public DJUnitEclipseClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void initialize(String[] args) {
        this.messageSender = new MessageSender();
        this.messageSender.initialize(args);
        this.messageSender.connect();
    }

    public void shutDownMessageSender() {
        if (this.messageSender != null) {
            this.messageSender.shutDown();
        }
    }

    public void sendMessage(String message) {
        if (message == null) {
            return;
        }
        if (this.messageSender != null) {
            this.messageSender.sendMessage(message);
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.sendMessage(DJUnitMessages.getFormattedString("DJUnitTestCaseClassLoader.message.loadingclass", name));
        Class c = super.loadClass(name, resolve);
        this.sendMessage(DJUnitMessages.getFormattedString("DJUnitTestCaseClassLoader.message.loadedclass", name));
        return c;
    }

    protected Class defineClass(String name, byte[] data) {
        Class c = super.defineClass(name, data);
        this.sendMessage(DJUnitMessages.getFormattedString("DJUnitTestCaseClassLoader.message.modifiedclass", name));
        return c;
    }
}

