/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dgic.testing.common;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class BcelJUnit4AnnotationReader {
    private final String ATTR_NAME_ANNOTATION = "RuntimeVisibleAnnotations";
    private static final String JUNIT4_TEST_ANNOTATION = "org/junit/";
    private static final String JUNIT4_TESTRUNNER_ANNOTATION = "org/junit/runner";
    private boolean hasJUnit4Annotation = false;

    public BcelJUnit4AnnotationReader(JavaClass jc) {
        this.readAnnotations(jc);
    }

    public boolean hasJUnit4Annotation() {
        return this.hasJUnit4Annotation;
    }

    private void readAnnotations(JavaClass jc) {
        Attribute[] attrs = jc.getAttributes();
        this.checkUnknownAttributes(attrs);
        Method[] ms = jc.getMethods();
        int i = 0;
        while (i < ms.length) {
            if (this.hasJUnit4Annotation) {
                return;
            }
            this.checkUnknownAttributes(ms[i].getAttributes());
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void checkUnknownAttributes(Attribute[] attrs) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 140->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkType(DataInputStream in, ConstantPool cp) throws IOException {
        short typeIndex = in.readShort();
        String type = cp.constantToString(cp.getConstant((int)typeIndex));
        if (this.isJUnit4Annotation(type)) {
            this.hasJUnit4Annotation = true;
            return true;
        }
        int numMVPairs = in.readShort();
        int i = 0;
        while (i < numMVPairs) {
            in.readShort();
            this.skipReadValue(in, cp);
            ++i;
        }
        return false;
    }

    private void skipReadValue(DataInputStream in, ConstantPool cp) throws IOException {
        in.readByte();
        in.readShort();
    }

    private boolean isJUnit4Annotation(String type) {
        if (type == null) {
            return false;
        }
        if (type.indexOf(JUNIT4_TEST_ANNOTATION) >= 0) {
            return true;
        }
        return type.indexOf(JUNIT4_TESTRUNNER_ANNOTATION) >= 0;
    }
}

