/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.export.conf.logtransfer;

import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.logtransfer.bean.LogTransferFileInfo;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.ejb.session.LogTransferController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.util.Messages;
import jp.co.intellilink.hinemos.util.StringListComparator;
import jp.co.intellilink.hinemos.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportLogTransfer {
    private static Log log = LogFactory.getLog(ExportLogTransfer.class);

    public void exportLogTransfer() {
        log.info((Object)Messages.getMsg("LogTransfer.Start", new String[]{Messages.getMsg("ExportTool.Export")}));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getLogTransferIdList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(0)};
                log.info((Object)Messages.getMsg("TransferID", objectArray));
                LogTransferInfo logTransferInfo = this.getLogTransfer((String)arrayList3.get(0));
                arrayList.add(this.createCsvFormat(logTransferInfo));
            }
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Export.Dir") + "/LOGTRANSFER_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)Messages.getMsg("LogTransfer.End", new String[]{Messages.getMsg("ExportTool.Export")}));
    }

    public ArrayList<String> createCsvFormat(LogTransferInfo logTransferInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(logTransferInfo.getTransferId());
        arrayList.add(logTransferInfo.getDescription());
        arrayList.add(logTransferInfo.getFacilityId());
        Iterator iterator = logTransferInfo.getFileInfo().iterator();
        if (iterator.hasNext()) {
            LogTransferFileInfo logTransferFileInfo = (LogTransferFileInfo)iterator.next();
            arrayList.add(logTransferFileInfo.getFilePath());
            arrayList.add(String.valueOf(logTransferFileInfo.getRunInterval()));
            arrayList.add(YesNoConstant.typeToString((int)logTransferFileInfo.getExistenceFlg()));
            arrayList.add(ValidConstant.typeToString((int)logTransferFileInfo.getValid()));
        }
        arrayList.add(ValidConstant.typeToString((int)logTransferInfo.getValid()));
        return arrayList;
    }

    protected LogTransferInfo getLogTransfer(String string) {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        LogTransferInfo logTransferInfo = null;
        try {
            logTransferInfo = logTransferController.getLogTransfer(string);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return logTransferInfo;
    }

    protected ArrayList getLogTransferIdList() {
        LogTransferController logTransferController = EjbConnectionManager.getConnectionManager().getLogTransferController();
        ArrayList arrayList = null;
        try {
            arrayList = logTransferController.getLogTransferList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

