/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.repository;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyTreeItem;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.util.CheckString;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportNode {
    private static Log log = LogFactory.getLog(ImportNode.class);
    private ArrayList<Property> nodeList = null;
    private ArrayList<ArrayList<String>> nodeInfos = null;

    public void importNode() {
        log.info((Object)Messages.getMsg("ImportTool.Node.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.nodeInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/NODE.csv");
        this.nodeList = this.getNodeList();
        for (ArrayList<String> arrayList : this.nodeInfos) {
            Property property = this.createNodeInfo(arrayList);
            this.registerNodeInfo(property);
        }
        log.info((Object)Messages.getMsg("ImportTool.Node.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    public Property createNodeInfo(ArrayList<String> arrayList) {
        Object object;
        Object object2;
        Property property = this.getNodeProperty();
        ArrayList arrayList2 = null;
        String string = CheckString.checkLength(arrayList.get(0), 64);
        if (!string.equals(arrayList.get(0))) {
            object2 = new String[]{com.clustercontrol.util.Messages.getString((String)"facility.id"), "64"};
            log.error((Object)Messages.getMsg("ImportTool.Common.2", (Object[])object2));
            System.exit(20);
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"facilityId");
        ((Property)arrayList2.get(0)).setValue((Object)string);
        object2 = CheckString.checkLength(arrayList.get(1), 256);
        if (!((String)object2).equals(arrayList.get(1))) {
            object = new String[]{com.clustercontrol.util.Messages.getString((String)"facility.name"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", (Object[])object));
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"facilityName");
        ((Property)arrayList2.get(0)).setValue(object2);
        object = CheckString.checkLength(arrayList.get(2), 1024);
        if (!((String)object).equals(arrayList.get(2))) {
            Object[] objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"description"), "1024"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"description");
        ((Property)arrayList2.get(0)).setValue(object);
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"platformFamilyName");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(3));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"hardwareType");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(4));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"iconImage");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(5));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"valid");
        ((Property)arrayList2.get(0)).setValue((Object)YesNoConstant.typeToBoolean((int)YesNoConstant.stringToType((String)arrayList.get(6))));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"snmpPort");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)Integer.parseInt(arrayList.get(7)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"snmpCommunity");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(8));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"snmpVersion");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(9));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"snmpVersion");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)Integer.parseInt(arrayList.get(10)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"snmpRetries");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)Integer.parseInt(arrayList.get(11)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"snmpProxy");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(12));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"dhcpClient");
        ((Property)arrayList2.get(0)).setValue((Object)YesNoConstant.typeToBoolean((int)YesNoConstant.stringToType((String)arrayList.get(13))));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"ipAddressType");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)Integer.parseInt(arrayList.get(14)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"ipAddressVersion");
        try {
            ((Property)arrayList2.get(0)).setValue((Object)Integer.parseInt(arrayList.get(15)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"ipAddressV4");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(16));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"ipAddressV6");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(17));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"hostName");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(18));
        arrayList2 = PropertyUtil.getProperty((Property)property, (String)"nodeName");
        ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(19));
        if (arrayList.size() >= 21) {
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"osName");
            ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(20));
        }
        if (arrayList.size() >= 22) {
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"osRelease");
            ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(21));
        }
        if (arrayList.size() >= 23) {
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"osVersion");
            ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(22));
        }
        if (arrayList.size() >= 24) {
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"characterSet");
            ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(23));
        }
        if (arrayList.size() >= 25) {
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"virtualizationNodeType");
            ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(24));
        }
        if (arrayList.size() >= 26) {
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"vMManagementNode");
            ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(25));
        }
        if (arrayList.size() >= 27) {
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"VMINDEX");
            try {
                ((Property)arrayList2.get(0)).setValue((Object)Integer.parseInt(arrayList.get(26)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (arrayList.size() >= 28) {
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"VMName");
            ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(27));
        }
        if (arrayList.size() >= 29) {
            arrayList2 = PropertyUtil.getProperty((Property)property, (String)"virtualizationSolution");
            ((Property)arrayList2.get(0)).setValue((Object)arrayList.get(28));
        }
        return property;
    }

    protected Property checkNodeList(String string) {
        ArrayList arrayList = null;
        for (Property property : this.nodeList) {
            arrayList = PropertyUtil.getProperty((Property)property, (String)"facilityId");
            String string2 = (String)((Property)arrayList.get(0)).getValue();
            if (string2.compareTo(string) != 0) continue;
            return property;
        }
        return null;
    }

    protected void registerNodeInfo(Property property) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList arrayList = null;
        arrayList = PropertyUtil.getProperty((Property)property, (String)"facilityId");
        String string = (String)((Property)arrayList.get(0)).getValue();
        try {
            Property property2 = this.checkNodeList(string);
            if (property2 instanceof Property) {
                arrayList = PropertyUtil.getProperty((Property)property2, (String)"createTimestamp");
                Date date = (Date)((Property)arrayList.get(0)).getValue();
                arrayList = PropertyUtil.getProperty((Property)property2, (String)"creatorName");
                String string2 = (String)((Property)arrayList.get(0)).getValue();
                arrayList = PropertyUtil.getProperty((Property)property, (String)"createTimestamp");
                ((Property)arrayList.get(0)).setValue((Object)date);
                arrayList = PropertyUtil.getProperty((Property)property, (String)"creatorName");
                ((Property)arrayList.get(0)).setValue((Object)string2);
                this.copyDeviceProperty(property, property2);
                this.copyFileSystemProperty(property, property2);
                Object[] objectArray = new Object[]{string};
                log.info((Object)(Messages.getMsg("ImportTool.FacilityID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                repositoryController.modifyNode(property);
            } else {
                Object[] objectArray = new Object[]{string};
                log.info((Object)(Messages.getMsg("ImportTool.FacilityID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                repositoryController.addNode(property);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{string};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected void copyDeviceProperty(Property property, Property property2) {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        arrayList = PropertyUtil.getProperty((Property)property, (String)"device");
        Property property3 = (Property)arrayList.get(0);
        int n = PropertyUtil.getPropertyIndex((Property)property, (Property)property3);
        arrayList2 = PropertyUtil.getProperty((Property)property2, (String)"device");
        for (int i = 0; i < arrayList2.size(); ++i) {
            Property property4 = (Property)arrayList2.get(i);
            ArrayList arrayList3 = PropertyUtil.getProperty((Property)property4, (String)"deviceName");
            ArrayList arrayList4 = PropertyUtil.getProperty((Property)property4, (String)"deviceOID");
            ArrayList arrayList5 = PropertyUtil.getProperty((Property)property4, (String)"deviceIndex");
            ArrayList arrayList6 = PropertyUtil.getProperty((Property)property4, (String)"deviceType");
            ArrayList arrayList7 = PropertyUtil.getProperty((Property)property4, (String)"deviceDescription");
            if (i == 0) {
                property3.setValue(((Property)arrayList3.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"deviceName");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList3.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"deviceOID");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList4.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"deviceIndex");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList5.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"deviceType");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList6.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"deviceDescription");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList7.get(0)).getValue());
                continue;
            }
            Property property5 = PropertyUtil.copy((Property)property3);
            property5.setValue(((Property)arrayList3.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"deviceName");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList3.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"deviceOID");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList4.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"deviceIndex");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList5.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"deviceType");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList6.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"deviceDescription");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList7.get(0)).getValue());
            property.addChildren((PropertyTreeItem)property5, n + i);
        }
    }

    protected void copyFileSystemProperty(Property property, Property property2) {
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        arrayList = PropertyUtil.getProperty((Property)property, (String)"fileSystem");
        Property property3 = (Property)arrayList.get(0);
        int n = PropertyUtil.getPropertyIndex((Property)property, (Property)property3);
        arrayList2 = PropertyUtil.getProperty((Property)property2, (String)"fileSystem");
        for (int i = 0; i < arrayList2.size(); ++i) {
            Property property4 = (Property)arrayList2.get(i);
            ArrayList arrayList3 = PropertyUtil.getProperty((Property)property4, (String)"fileSystemIndex");
            ArrayList arrayList4 = PropertyUtil.getProperty((Property)property4, (String)"fileSystemMountPoint");
            ArrayList arrayList5 = PropertyUtil.getProperty((Property)property4, (String)"fileSystemOID");
            ArrayList arrayList6 = PropertyUtil.getProperty((Property)property4, (String)"fileSystemType");
            ArrayList arrayList7 = PropertyUtil.getProperty((Property)property4, (String)"fileSystemDescription");
            if (i == 0) {
                property3.setValue(((Property)arrayList4.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"fileSystemIndex");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList3.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"fileSystemMountPoint");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList4.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"fileSystemOID");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList5.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"fileSystemType");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList6.get(0)).getValue());
                arrayList = PropertyUtil.getProperty((Property)property3, (String)"fileSystemDescription");
                ((Property)arrayList.get(0)).setValue(((Property)arrayList7.get(0)).getValue());
                continue;
            }
            Property property5 = PropertyUtil.copy((Property)property3);
            property5.setValue(((Property)arrayList4.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"fileSystemIndex");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList3.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"fileSystemMountPoint");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList4.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"fileSystemOID");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList5.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"fileSystemType");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList6.get(0)).getValue());
            arrayList = PropertyUtil.getProperty((Property)property5, (String)"fileSystemDescription");
            ((Property)arrayList.get(0)).setValue(((Property)arrayList7.get(0)).getValue());
            property.addChildren((PropertyTreeItem)property5, n + i);
        }
    }

    protected Property getNodeProperty() {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        Property property = null;
        try {
            property = repositoryController.getNodeProperty("", 0, Locale.getDefault());
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return property;
    }

    protected ArrayList<Property> getNodeList() {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList<Property> arrayList = new ArrayList<Property>();
        try {
            ArrayList arrayList2 = repositoryController.getNodeFacilityIdList();
            for (String string : arrayList2) {
                Property property = repositoryController.getNodeProperty(string, 2, Locale.getDefault());
                arrayList.add(property);
            }
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

