/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.bean.PingRunCountConstant;
import com.clustercontrol.bean.PingRunIntervalConstant;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.ping.bean.MonitorPingInfo;
import com.clustercontrol.ping.ejb.session.MonitorPingController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorPing
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorPing.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfos = null;

    public void importPing() {
        log.info((Object)Messages.getMsg("ImportTool.Ping.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfos = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/PING.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfos) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("ImportTool.Ping.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 8), monitorInfo);
        this.createMonitorBlock(arrayList.subList(8, 9), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(9, 14), monitorInfo);
        this.createMonitorNotify(arrayList.subList(14, 19), monitorInfo);
        this.createMonitorApplication(arrayList.subList(19, 20), monitorInfo);
        this.createMonitorVaild(arrayList.subList(20, 21), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        MonitorPingInfo monitorPingInfo = new MonitorPingInfo();
        monitorPingInfo.setRunCount(Integer.valueOf(PingRunCountConstant.stringToType((String)list.get(0))));
        monitorPingInfo.setRunInterval(Integer.valueOf(PingRunIntervalConstant.stringToType((String)list.get(1))));
        monitorPingInfo.setTimeout(Integer.valueOf(Integer.parseInt(list.get(2))));
        monitorInfo.setCheckInfo((MonitorCheckInfo)monitorPingInfo);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorPingController monitorPingController = EjbConnectionManager.getConnectionManager().getMonitorPingController();
        try {
            ArrayList arrayList = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                monitorInfo.setRegDate(new Timestamp(date.getTime()));
                monitorInfo.setRegUser(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorPingController.modifyPing(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorPingController.addPing(monitorInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{monitorInfo.getMonitorId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorPingController monitorPingController = EjbConnectionManager.getConnectionManager().getMonitorPingController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorPingController.getPingList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

