/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.test.performance;

import com.clustercontrol.performance.bean.CollectorProperty;
import com.clustercontrol.performance.ejb.bmp.RecordCollectorData;
import com.clustercontrol.performance.ejb.session.CollectorController;
import com.clustercontrol.repository.ejb.session.RepositoryController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import jp.co.intellilink.hinemos.test.performance.CheckRecordData;
import jp.co.intellilink.hinemos.test.util.Config;
import jp.co.intellilink.hinemos.test.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.test.util.Messages;
import jp.co.intellilink.hinemos.test.util.StringListComparator;
import jp.co.intellilink.hinemos.test.util.WriteCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckResultPerformance {
    private static Log log = LogFactory.getLog(CheckResultPerformance.class);

    public void checkResult() {
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Performance.Start")));
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList arrayList2 = this.getPerformanceList();
        if (arrayList2 instanceof ArrayList) {
            for (ArrayList arrayList3 : arrayList2) {
                Object[] objectArray = new Object[]{(String)arrayList3.get(2)};
                log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.CollectorID", objectArray)));
                CollectorProperty collectorProperty = this.getPerformance((String)arrayList3.get(2));
                arrayList.addAll(this.createCheckResult(collectorProperty));
            }
            Collections.sort(arrayList, new StringListComparator(2));
            Collections.sort(arrayList, new StringListComparator(1));
            Collections.sort(arrayList, new StringListComparator(0));
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        WriteCsvFile.writeCsvFile(Config.getConfig("Check.Output.Dir") + "/PERFORMANCE_" + simpleDateFormat.format(new Date()) + ".csv", arrayList);
        log.info((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.Performance.End")));
    }

    public ArrayList<ArrayList<String>> createCheckResult(CollectorProperty collectorProperty) {
        ArrayList<ArrayList<String>> arrayList = new ArrayList<ArrayList<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        RecordCollectorData recordCollectorData = collectorProperty.getCollectorData();
        arrayList2.addAll(this.getNodeList(recordCollectorData.getFacilityID()));
        for (String string : arrayList2) {
            CheckRecordData checkRecordData = new CheckRecordData(collectorProperty, string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
            String string2 = Config.getConfig("Check.Output.Dir") + "/PERFORMANCE_(" + recordCollectorData.getCollectorID() + ")_" + simpleDateFormat.format(new Date()) + ".csv";
            checkRecordData.write(string2);
            arrayList.addAll(checkRecordData.check());
        }
        return arrayList;
    }

    protected ArrayList<String> getNodeList(String string) {
        RepositoryController repositoryController = EjbConnectionManager.getConnectionManager().getRepositoryController();
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (repositoryController.isNode(string)) {
                arrayList.add(string);
            } else {
                arrayList.addAll(repositoryController.getExecTargetFacilityIdList(string));
            }
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }

    protected CollectorProperty getPerformance(String string) {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        CollectorProperty collectorProperty = null;
        try {
            collectorProperty = collectorController.getCollectorProperty(string);
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return collectorProperty;
    }

    protected ArrayList getPerformanceList() {
        CollectorController collectorController = EjbConnectionManager.getConnectionManager().getCollectorController();
        ArrayList arrayList = null;
        try {
            arrayList = collectorController.getCollectionList();
        }
        catch (Exception exception) {
            log.error((Object)("[" + Messages.getMsg("CheckResult") + "] " + Messages.getMsg("TestTool.ConnectManagerFailed")), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

