/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.jmx;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import jp.co.intellilink.hinemos.jmx.OutputMBeanAttribute;
import jp.co.intellilink.hinemos.util.Config;
import jp.co.intellilink.hinemos.util.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMXTool {
    private static Log log = LogFactory.getLog(JMXTool.class);
    protected Timer timer = new Timer(true);
    private HashMap<String, String> mbeanMap = new HashMap();

    public JMXTool() {
        for (int i = 1; i <= 100; ++i) {
            String string = Config.getConfig("MBean.Name." + i);
            String string2 = Config.getConfig("MBean.FileName." + i);
            if (string.length() <= 0 || string2.length() <= 0) break;
            this.mbeanMap.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        log.info((Object)Messages.getMsg("JMXTool.Exec"));
        JMXTool jMXTool = new JMXTool();
        jMXTool.exec();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            Object object;
            try {
                object = bufferedReader.readLine();
                if (((String)object).equals("quit")) {
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = jMXTool;
            synchronized (object) {
                jMXTool.wait();
            }
        }
        jMXTool.terminate();
        log.info((Object)Messages.getMsg("JMXTool.Exit"));
        System.exit(0);
    }

    public void exec() {
        String string = Config.getConfig("Interval");
        Long l = Long.parseLong(string);
        this.timer.schedule((TimerTask)new CheckTask(), l, (long)l);
    }

    public void terminate() {
        this.timer.cancel();
    }

    public void check() {
        OutputMBeanAttribute outputMBeanAttribute = new OutputMBeanAttribute();
        for (String string : this.mbeanMap.keySet()) {
            outputMBeanAttribute.check(string, this.mbeanMap.get(string));
        }
    }

    protected class CheckTask
    extends TimerTask {
        protected CheckTask() {
        }

        public void run() {
            JMXTool.this.check();
        }
    }
}

