/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.hinemos.importtool.conf.monitor;

import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.sql.bean.MonitorSqlInfo;
import com.clustercontrol.sql.ejb.session.MonitorSqlController;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ejb.DuplicateKeyException;
import jp.co.intellilink.hinemos.importtool.conf.monitor.ImportMonitorNumeric;
import jp.co.intellilink.hinemos.importtool.conf.monitor.JdbcDriverUtil;
import jp.co.intellilink.hinemos.importtool.util.CheckString;
import jp.co.intellilink.hinemos.importtool.util.Config;
import jp.co.intellilink.hinemos.importtool.util.EjbConnectionManager;
import jp.co.intellilink.hinemos.importtool.util.Messages;
import jp.co.intellilink.hinemos.importtool.util.ReadCsvFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportMonitorSql
extends ImportMonitorNumeric {
    private static Log log = LogFactory.getLog(ImportMonitorSql.class);
    private ArrayList monitorList = null;
    private ArrayList<ArrayList<String>> monitorInfo = null;

    public void importSql() {
        log.info((Object)Messages.getMsg("ImportTool.Sql.Start", new String[]{Messages.getMsg("ImportTool.Import")}));
        this.monitorInfo = ReadCsvFile.readCsvFile(Config.getConfig("Input.Dir.Conf") + "/SQL.csv");
        this.monitorList = this.getMonitorList();
        for (ArrayList<String> arrayList : this.monitorInfo) {
            MonitorInfo monitorInfo = this.createMonitorInfo(arrayList);
            this.registerMonitorInfo(monitorInfo);
        }
        log.info((Object)Messages.getMsg("ImportTool.Sql.End", new String[]{Messages.getMsg("ImportTool.Import")}));
    }

    @Override
    protected MonitorInfo createMonitorInfo(ArrayList<String> arrayList) {
        MonitorInfo monitorInfo = new MonitorInfo();
        this.createMonitorBase(arrayList, monitorInfo);
        this.createMonitorRule(arrayList.subList(3, 5), monitorInfo);
        this.createMonitorCheck(arrayList.subList(5, 10), monitorInfo);
        this.createMonitorJudgement(arrayList.subList(10, 15), monitorInfo);
        this.createMonitorNotify(arrayList.subList(15, 20), monitorInfo);
        this.createMonitorApplication(arrayList.subList(20, 21), monitorInfo);
        this.createMonitorMessages(arrayList.subList(21, 27), monitorInfo);
        this.createMonitorVaild(arrayList.subList(27, 28), monitorInfo);
        return monitorInfo;
    }

    @Override
    protected void createMonitorCheck(List<String> list, MonitorInfo monitorInfo) {
        Object[] objectArray;
        Object[] objectArray2;
        MonitorSqlInfo monitorSqlInfo = new MonitorSqlInfo();
        String string = CheckString.checkLength(list.get(0), 256);
        if (!string.equals(list.get(0))) {
            objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"connection.url"), "256"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
        }
        monitorSqlInfo.setConnectionUrl(string);
        objectArray2 = JdbcDriverUtil.getJdbcDriver();
        for (List<String> object2 : objectArray2) {
            objectArray = object2.get(0);
            if (!objectArray.equals(list.get(1))) continue;
            monitorSqlInfo.setJdbcDriver(object2.get(1));
            break;
        }
        String string2 = CheckString.checkLength(list.get(2), 64);
        if (!string.equals(list.get(2))) {
            Object[] objectArray3 = new String[]{com.clustercontrol.util.Messages.getString((String)"user.id"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray3));
        }
        monitorSqlInfo.setUser(string2);
        String string3 = CheckString.checkLength(list.get(3), 64);
        if (!string3.equals(list.get(3))) {
            objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"password"), "64"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
        }
        monitorSqlInfo.setPassword(string3);
        objectArray = CheckString.checkLength(list.get(4), 1024);
        if (!objectArray.equals(list.get(4))) {
            Object[] objectArray4 = new String[]{com.clustercontrol.util.Messages.getString((String)"sql.string"), "1024"};
            log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray4));
        }
        monitorSqlInfo.setQuery((String)objectArray);
        monitorInfo.setCheckInfo((MonitorCheckInfo)monitorSqlInfo);
        monitorInfo.setMonitorType(1);
        super.createMonitorCheck(list, monitorInfo);
    }

    protected void createMonitorMessages(List<String> list, MonitorInfo monitorInfo) {
        ArrayList arrayList = monitorInfo.getJudgementInfo();
        for (MonitorNumericValueInfo monitorNumericValueInfo : arrayList) {
            Object[] objectArray;
            if (monitorNumericValueInfo.getPriority() == 3) {
                monitorNumericValueInfo.setMessageId(list.get(0));
                monitorNumericValueInfo.setMessage(list.get(1));
            } else if (monitorNumericValueInfo.getPriority() == 2) {
                monitorNumericValueInfo.setMessageId(list.get(2));
                monitorNumericValueInfo.setMessage(list.get(3));
            } else if (monitorNumericValueInfo.getPriority() == 0) {
                monitorNumericValueInfo.setMessageId(list.get(4));
                monitorNumericValueInfo.setMessage(list.get(5));
            }
            String string = CheckString.checkLength(monitorNumericValueInfo.getMessageId(), 64);
            if (!string.equals(monitorNumericValueInfo.getMessageId())) {
                objectArray = new String[]{com.clustercontrol.util.Messages.getString((String)"message.id"), "64"};
                log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray));
            }
            monitorNumericValueInfo.setMessageId(string);
            objectArray = CheckString.checkLength(monitorNumericValueInfo.getMessage(), 256);
            if (!objectArray.equals(monitorNumericValueInfo.getMessage())) {
                Object[] objectArray2 = new String[]{com.clustercontrol.util.Messages.getString((String)"message"), "256"};
                log.warn((Object)Messages.getMsg("ImportTool.Common.2", objectArray2));
            }
            monitorNumericValueInfo.setMessage((String)objectArray);
        }
    }

    protected void registerMonitorInfo(MonitorInfo monitorInfo) {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        try {
            ArrayList arrayList = this.checkMonitorList(monitorInfo.getMonitorId(), this.monitorList);
            if (arrayList instanceof ArrayList) {
                Date date = (Date)arrayList.get(8);
                String string = (String)arrayList.get(7);
                monitorInfo.setRegDate(new Timestamp(date.getTime()));
                monitorInfo.setRegUser(string);
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("modify") + ")"));
                monitorSqlController.modifySql(monitorInfo);
            } else {
                Object[] objectArray = new Object[]{monitorInfo.getMonitorId()};
                log.info((Object)(Messages.getMsg("ImportTool.MonitorID", objectArray) + " (" + Messages.getMsg("add") + ")"));
                monitorSqlController.addSql(monitorInfo);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            Object[] objectArray = new String[]{monitorInfo.getMonitorId()};
            log.error((Object)Messages.getMsg("ImportTool.Common.1", objectArray));
            System.exit(20);
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
    }

    protected ArrayList getMonitorList() {
        MonitorSqlController monitorSqlController = EjbConnectionManager.getConnectionManager().getMonitorSqlController();
        ArrayList arrayList = null;
        try {
            arrayList = monitorSqlController.getSqlList();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMsg("ImportTool.ConnectManagerFailed"), (Throwable)exception);
            System.exit(14);
        }
        return arrayList;
    }
}

